﻿using SIMS.Entities;
using SIMS.Processes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace SIMSInterface
{
    public class Attendance
    {
        private static Dictionary<string, int> _AttendanceYearGroups = new Dictionary<string, int>();   
        public static Dictionary<string,int> AttendanceYearGroups
        {
            get
            {
                if (_AttendanceYearGroups.Count == 0)
                {
                    SIMS.Processes.GroupCache.Populate();
                    foreach (YearGroup y in SIMS.Entities.GroupCache.YearGroups)
                    {
                        _AttendanceYearGroups.Add(y.Code, y.ID);
                    }
                }
                return _AttendanceYearGroups;
            }
        }

        private static Dictionary<string, int> _AttendanceRegGroups = new Dictionary<string, int>();
        public static Dictionary<string, int> AttendanceRegGroups
        {
            get
            {
                if (_AttendanceRegGroups.Count == 0)
                {
                    SIMS.Processes.GroupCache.Populate();
                    foreach (RegistrationGroup r in SIMS.Entities.GroupCache.RegistrationGroups)
                    {
                        _AttendanceRegGroups.Add(r.Code, r.ID);
                    }
                }
                return _AttendanceRegGroups;
            }
        }
        public static XmlDocument GetAttendanceForYearGroup(string YearGroup, DateTime Start, DateTime End)
        {
            XmlDocument doc = null;
            int SampleGroup = -1;
            if (AttendanceYearGroups.TryGetValue(YearGroup, out SampleGroup))
            {
               doc = GetAttendanceForGroup(SampleGroup, Start, End);    
            }
            return doc;
        }
        public static XmlDocument GetAttendanceForRegGroup(string RegGroup, DateTime Start, DateTime End)
        {
            XmlDocument doc = null;
            int SampleGroup = -1;
            if (AttendanceRegGroups.TryGetValue(RegGroup, out SampleGroup))
            {
                doc = GetAttendanceForGroup(SampleGroup, Start, End);
            }
            return doc;
        }

        public static XmlDocument GetAttendanceForGroup(int GroupId, DateTime Start, DateTime End)
        {
            SIMS.Processes.TPAttendanceRead ATR = new SIMS.Processes.TPAttendanceRead();
            // XML Document needed to get the codes
            XmlDocument doc = new System.Xml.XmlDocument();
            // This is the actual call to get the codes
            doc.InnerXml = ATR.GetXmlSessionAttendancesExtended(0, GroupId, Start.Date, End);
            return doc;
        }
        public static XmlDocument GetChangeAttendance(DateTime Start)
        {
            DateTime End = DateTime.Now;
            XmlDocument d = new XmlDocument();
            TPAttendanceRead tpar = new TPAttendanceRead();
            d.InnerXml = tpar.GetXmlChangedSessionAttendancesInRange(Start, End);
            return d;
        }
    }
}
