﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2022
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;

namespace SIMSInterface
{
    public class SIMSLocation
    {
        //Private Import to read INI Files
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string section, string key, string def, StringBuilder retVal, int size, string filePath);

        /// <summary>
        /// Simple mechanism to return the SIMS .Net directory.  Just wraps existing code from Vivo.
        /// </summary>
        public static string SIMSDotNetDirectory
        {
            get
            {
                string rc = "";
                try
                {
                    StringBuilder SIMSFolder = new StringBuilder();
                    string SIMSIniFile = Path.Combine(System.Environment.GetFolderPath(Environment.SpecialFolder.Windows), "SIMS.INI");
                    if (File.Exists(SIMSIniFile))
                    {
                        GetPrivateProfileString("Setup", "SIMSDotNetDirectory", "", SIMSFolder, 0xff, SIMSIniFile);
                        if (!string.IsNullOrEmpty(SIMSFolder.ToString()))
                        {
                            return SIMSFolder.ToString();
                        }
                    }

                }
                catch
                {
                    // Almost doesn't matter why!
                }
                return rc;  // Empty string returned on failure
            }
        }
    }
}
