﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2022
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------
using System.Data;
using SIMS.Entities;
using SIMS.Processes;

namespace SIMSInterface
{
    public class TPAFessProcessTransactionDetails
    {
        private FeesImportProcess importProcess = new FeesImportProcess();
        private SIMS.Processes.FeesTransactionBatchDetail hostedProcess;
        private DataSet importData;
        private EntityAttribute oldTransactionType
            = new EntityAttribute(InformationDomainEnum.None, new AbstractCollectionReference(SIMS.Entities.FeesCache.GetAllTransactionTypes));
        private string ImportFileName = "";
        private string BatchDescription = "";
        public TPAFessProcessTransactionDetails(string _BatchDescription, string _ImportFileName)
        {
            ImportFileName = _ImportFileName;
            BatchDescription = _BatchDescription;
        }
        public void Go()
        { 
            this.hostedProcess = new FeesTransactionBatchDetail();
            this.hostedProcess.AddNew();
            this.hostedProcess.TransactionBatch.SetBatchLine(this.hostedProcess.GetNewBatchLine());
            this.hostedProcess.TransactionBatch.DescriptionAttribute.Value = BatchDescription;

            this.hostedProcess.CurrentEnterBy = new SIMS.Entities.FeesBatchEnterBy { Code = "5", Description = "Import Transaction Batch", ID = 4 };
            this.hostedProcess.TransactionBatch.BatchLine.TransactionTypeAttribute.Value
                = SIMS.Entities.FeesCache.GetTransactionTypeSummarys().ItemByString("Online Payment");

            this.hostedProcess.TransactionBatch.BatchLine.TransactionReferenceAttribute.Value
                = SIMS.Entities.FeesCache.GetTransactionTypeSummarys().ItemByString("Online Payment").ToString();

            //For Transaction Type "Online Payment" Base Transaction Type is Credit (check tables sims.fees_transaction_type, sims.fees_transaction_base_type)
            this.hostedProcess.TransactionBatch.BatchLine.TransactionBaseTypeAttribute.Value = "CREDIT";

            //Need to pass the GL code or look this up
            // alternatively a GL Description could be passed and use ItemByDescription
            this.hostedProcess.TransactionBatch.BatchLine.GLAccountAttribute.Value =
                SIMS.Entities.FeesCache.GetGeneralLedgers().ItemByCode("110-1202-01");

            importTransactionsData();


        }

        private void importTransactionsData()
        {
            importData = new DataSet();
            //need to pass file name
            importProcess.ImportTextFileName = ImportFileName;
            if (importProcess.ImportTextFileName.Trim().Length > 0)
            {
                importProcess.ReadTextFile(true);
                importData = importProcess.GetValidTransactionData();
            }

            this.hostedProcess.GenerateBatchLinesforImportedData(this.importData);
            this.updateTransactionBatchDetails();
            this.addTransaction();
            this.saveDetails();
        }

        private void updateTransactionBatchDetails()
        {
            this.hostedProcess.TransactionBatch.TotalAmount = 0;
            DoubleAttribute vatAmt = new DoubleAttribute(InformationDomainEnum.None);
            DoubleAttribute amt = new DoubleAttribute(InformationDomainEnum.None);

            foreach (FeesTransactionBatchLine line in this.hostedProcess.TransactionBatch.BatchLines.Value)
            {
                amt.Value += (line.TransactionBaseTypeAttribute.Value == "DEBIT" ? 1 : -1) * line.AmountAttribute.Value;
                vatAmt.Value += (line.TransactionBaseTypeAttribute.Value == "DEBIT" ? 1 : -1) * line.VatAmountAttribute.Value;
            }
            this.hostedProcess.TransactionBatch.TotalAmount = (amt.Value + vatAmt.Value);
            this.hostedProcess.TransactionBatch.TotalEntries = this.hostedProcess.TransactionBatch.BatchLines.Value.Count;
        }

        private void addTransaction()
        {
            if (this.hostedProcess.TransactionBatch.BatchLine == null)
            {
                return;
            }
            // preserve old values to be set again for new batch line
            DateAttribute dt = new DateAttribute(InformationDomainEnum.None);
            dt = this.hostedProcess.TransactionBatch.BatchLine.TransactionDateAttribute;
            EntityAttribute transType = new EntityAttribute(InformationDomainEnum.None);
            transType = this.hostedProcess.TransactionBatch.BatchLine.TransactionTypeAttribute;
            StringAttribute oldTransactionReferenceAttribute = new StringAttribute(false, InformationDomainEnum.None);
            oldTransactionReferenceAttribute.Value = this.hostedProcess.TransactionBatch.BatchLine.TransactionReferenceAttribute.Value;
            FeesGeneralLedger glAccount = new FeesGeneralLedger();
            glAccount = this.hostedProcess.TransactionBatch.BatchLine.GLAccount;

            this.hostedProcess.TransactionBatch.SetBatchLine(this.hostedProcess.GetNewBatchLine());
            // assign old values back to controls
            this.hostedProcess.TransactionBatch.BatchLine.TransactionDateAttribute.Value = dt.Value;
            this.hostedProcess.TransactionBatch.BatchLine.TransactionTypeAttribute.Value = transType.Value;
            this.oldTransactionType.Value = transType.Value;
            if (this.hostedProcess.TransactionBatch.BatchLine.TransactionBaseTypeAttribute.IsNull
                && !this.hostedProcess.TransactionBatch.BatchLine.TransactionTypeAttribute.IsNull)
            {
                this.hostedProcess.TransactionBatch.BatchLine.TransactionBaseTypeAttribute.Value = ((FeesTransactionTypeSummary)this.hostedProcess.TransactionBatch.BatchLine.TransactionTypeAttribute.Value).CreditAttribute.Value.Code;
            }
            this.hostedProcess.TransactionBatch.BatchLine.TransactionReferenceAttribute.Value = oldTransactionReferenceAttribute.Value;
            this.hostedProcess.TransactionBatch.BatchLine.GLAccount = new FeesGeneralLedger();
            if (this.hostedProcess.TransactionBatch.BatchLine.GLAccount != null && glAccount != null)
            {
                this.hostedProcess.TransactionBatch.BatchLine.GLAccount.Assign(glAccount);
            }
            this.hostedProcess.TransactionBatch.CurrentAllocations = new SIMS.Entities.FeesTransactions(InformationDomainEnum.None);
        }

        private bool saveDetails()
        {
            bool saved = false;
            try
            {
                if (this.hostedProcess.Valid())
                {
                    saved = this.hostedProcess.Save();
                }
                else if (this.hostedProcess.validationErrors.Count > 0)
                {
                    SIMS.Entities.ValidationError thisError = this.hostedProcess.validationErrors.Item(0);
                    // TI needs to do something with the error
                    //SIMS.Processes.Cache.StatusMessage(thisError.Message, UserMessageEventEnum.Error);
                }

            }
            catch (Exception ex)
            {
                // TI needs to do something with the error
            }

            return saved;
        }
    }
}
