﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2022
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------
using System;
using System.IO;


namespace Fees
{
    public class Program
    {
        private static string Server = ".";
        private static string Database = "Duchy2021";
        private static string User = "Fees";
        private static string Password = "Pa$$w0rd";

        static void Main(string[] args)
        {
            string file = Path.Combine(Environment.CurrentDirectory, "CMS - Fees Data Export v1.RptDef");
            SIMSInterface.SIMSDllResolution.AddSIMSDllResolution();
            DoTheRest();
         }
        static void DoTheRest()
        {
            // Login to SIMS
            if (SIMSInterface.LoginHelper.SIMSlogin(Server, Database, User, Password))
            {
                // Create a class to post a fees batch
                // takes a unique batch name and the file to import from
                // unfortunately a file in the format 
                // Payee Ref<tab>Bill Payer Ref<tab>Amount<tab>Admission Number
                // is required for the import.
                SIMSInterface.TPAFessProcessTransactionDetails feesPost =
                    new SIMSInterface.TPAFessProcessTransactionDetails("Unique Batch Name", @"c:\temp\FeesImport.txt");
                // Then invoke the import
                feesPost.Go();


                // Export balances
                //Report definition file name
                string ReportdefinitionFile = Path.Combine(System.Environment.CurrentDirectory,"Fees Data Export v1.RptDef");


                SIMSInterface.FeesBalanceSuperStarReport balancesSuperStarReport = SIMSInterface.Fees.GetBalances(ReportdefinitionFile,".", "DUCHY2021", "Fees", "Pa$$w0rd");
                // Export transactions
                SIMSInterface.TransactionsSuperStarReport transactionSuperStarReport = SIMSInterface.Fees.GetTransations(DateTime.Now.AddDays(-31), DateTime.Now, ReportdefinitionFile , ".", "DUCHY2021", "Fees", "Pa$$w0rd");

            }
        }
    }
}
