﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2022
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class FeesBalance
    {
        public int StudentID { get; set; }
        public Double Balance { get; set; }
    }
    public class FeesTransaction
    {
        public int BillPayerID { get; set; }    
        public DateTime TransactionDate { get; set; }
        public Double Amount { get; set; }
        public int StudentID { get; set; }
        public string Detail { get; set; }
        public Nullable<int> TransactionID { get; set; }
    }
    public class FeesTransactions
    {
        public int PersonID { get; set; }
        public List<FeesTransaction> Transactions { get; set; } 

    }
    public class Fees
    {
        class Entry
        {
            string PayerRef;
            string PupilRef;
            double? Amount;
        }
        public static  FeesBalanceSuperStarReport GetBalances(string _File, string Server, string Database, string User, string Password)
        {
            if (SIMSReportingEngine.ReportingEngine.Load(_File, Server, Database, User, Password))
            {
                XmlDocument d = SIMSReportingEngine.ReportingEngine.Run("Student Payer Balances", Server, Database, User, Password);

                XmlSerializer serializer = new XmlSerializer(typeof(FeesBalanceSuperStarReport));
                FeesBalanceSuperStarReport balances = null;
                using (StringReader reader = new StringReader(d.InnerXml))
                {
                    balances = (FeesBalanceSuperStarReport)serializer.Deserialize(reader);
                }
                return balances;
            }
            return null;
        }
        public static TransactionsSuperStarReport GetTransations(DateTime Start, DateTime End, string _File, string Server, string Database, string User, string Password)
        {
            if (SIMSReportingEngine.ReportingEngine.Load(_File, Server, Database, User, Password))
            {
                XmlDocument d = SIMSReportingEngine.ReportingEngine.Run("Fees Data Export Transactions v1", Server, Database, User, Password);
                XmlSerializer serializer = new XmlSerializer(typeof(TransactionsSuperStarReport));
                TransactionsSuperStarReport tssr = null;
                using (StringReader reader = new StringReader(d.InnerXml))
                {
                    tssr = (TransactionsSuperStarReport)serializer.Deserialize(reader);
                }
                return tssr;
            }
            return null;  
        }
    }
}
 