﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2022
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Xml.Serialization;
// XmlSerializer serializer = new XmlSerializer(typeof(SuperStarReport));
// using (StringReader reader = new StringReader(xml))
// {
//    var test = (SuperStarReport)serializer.Deserialize(reader);
// }
namespace SIMSInterface
{

	// using System.Xml.Serialization;
	// XmlSerializer serializer = new XmlSerializer(typeof(SuperStarReport));
	// using (StringReader reader = new StringReader(xml))
	// {
	//    var test = (SuperStarReport)serializer.Deserialize(reader);
	// }

	[XmlRoot(ElementName = "Record")]
	public class FeesBalanceRecord
	{
		/// <summary>
		/// The internal ID of the student
		/// </summary>
		[XmlElement(ElementName = "StudentID")]
		public int StudentID { get; set; }
		/// <summary>
		/// The Fees reference for a student
		/// </summary>
		[XmlElement(ElementName = "PupilReference")]
		public string PupilReference { get; set; }
		/// <summary>
		/// The external ID of the student
		/// </summary>
		[XmlElement(ElementName = "ExternalId")]
		public string ExternalId { get; set; }
		/// <summary>
		/// The outstanding balance for the bill payer who may have many pupils to pay for.
		/// </summary>
		[XmlElement(ElementName = "Payer_Outstanding_Balance")]
		public double? PayerOutstandingBalance { get; set; }
		/// <summary>
		/// The outstanding balance for that biil payer for this specifc student.  The total debt for the the student could be the sum of 
		/// many payers
		/// </summary>
		[XmlElement(ElementName = "Pupil_Payer_Outstanding_Balance")]
		public double? PupilPayerOutstandingBalance { get; set; }
		/// <summary>
		/// The payer reference -NB: there is no access to internal / external id in the reporting model at this time.
		/// We can however produce a report of external id, internal id & Payer Ref if 
		/// </summary>
		[XmlElement(ElementName = "PayerReference")]
		public string PayerReference { get; set; }
	}

	[XmlRoot(ElementName = "SuperStarReport")]
	public class FeesBalanceSuperStarReport
	{

		[XmlElement(ElementName = "Record")]
		public List<FeesBalanceRecord> Record { get; set; }
	}



	[XmlRoot(ElementName = "Record")]
	public class BalancesRecord
	{

		[XmlElement(ElementName = "ID")]
		public int ID { get; set; }

		[XmlElement(ElementName = "ExternalId")]
		public string ExternalId { get; set; }

		[XmlElement(ElementName = "DepositBalance")]
		public double DepositBalance { get; set; }

		[XmlElement(ElementName = "RegistrationFeesBalance")]
		public double RegistrationFeesBalance { get; set; }

		[XmlElement(ElementName = "AdvancedPaymentBalance")]
		public double AdvancedPaymentBalance { get; set; }
	}

	[XmlRoot(ElementName = "SuperStarReport")]
	public class BalancesSuperStarReport
	{

		[XmlElement(ElementName = "Record")]
		public List<BalancesRecord> Record { get; set; }
	}
	[XmlRoot(ElementName = "Record")]
	public class TransactionRecord
	{
		/// <summary>
		/// The Fees reference for a student
		/// </summary>
		[XmlElement(ElementName = "PupilReference")]
		public string PupilReference { get; set; }
		/// <summary>
		/// Internal ID of a Student
		/// </summary>
		[XmlElement(ElementName = "ID")]
		public int ID { get; set; }
		/// <summary>
		/// External ID of a student
		/// </summary>
		[XmlElement(ElementName = "ExternalId")]
		public string ExternalId { get; set; }
		/// <summary>
		/// Transaction type for this transaction
		/// </summary>
		[XmlElement(ElementName = "TransactionType")]
		public string TransactionType { get; set; }
		/// <summary>
		/// Description
		/// </summary>
		[XmlElement(ElementName = "TransactionDescription")]
		public string TransactionDescription { get; set; }
		/// <summary>
		/// Amount of the transaction
		/// </summary>
		[XmlElement(ElementName = "Amount")]
		public double? Amount { get; set; }
		/// <summary>
		/// VAT amount of the transaction
		/// </summary>
		[XmlElement(ElementName = "VATAmount")]
		public double? VATAmount { get; set; }
		/// <summary>
		/// Amount + VAT
		/// </summary>
		[XmlElement(ElementName = "GrossAmount")]
		public double? GrossAmount { get; set; }
		/// <summary>
		/// Transaction Date
		/// </summary>
		[XmlElement(ElementName = "Date")]
		public DateTime? Date { get; set; }
		/// <summary>
		/// Transaction batch number
		/// </summary>
		[XmlElement(ElementName = "BatchNumber")]
		public string BatchNumber { get; set; }
		/// <summary>
		/// Sequence number in the batch
		/// </summary>
		[XmlElement(ElementName = "BatchSequence")]
		public string BatchSequence { get; set; }
		/// <summary>
		/// Reference of Payer
		/// </summary>
		[XmlElement(ElementName = "PayerReference")]
		public string PayerReference { get; set; }
		/// <summary>
		/// Amount allocated
		/// </summary>
		[XmlElement(ElementName = "AmountAllocated")]
		public double? AmountAllocated { get; set; }
		/// <summary>
		/// Amount available to allocate
		/// </summary>
		[XmlElement(ElementName = "AmountUnallocated")]
		public double? AmountUnallocated { get; set; }
		/// <summary>
		/// Transaction Type
		/// </summary>
		[XmlElement(ElementName = "Type")]
		public string Type { get; set; }
		/// <summary>
		/// Disputed flag
		/// </summary>
		[XmlElement(ElementName = "DisputedBill")]
		public string DisputedBill { get; set; }
	}

	[XmlRoot(ElementName = "SuperStarReport")]
	public class TransactionsSuperStarReport
	{

		[XmlElement(ElementName = "Record")]
		public List<TransactionRecord> Record { get; set; }
	}


}
