﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace GetMyCreds
{
    public class AuthRequest
    {
        /// <summary>
        /// Token server address
        /// partner support to provide
        /// </summary>
        public string STS { get; set; }
        /// <summary>
        /// For each school you get a client id and a secret
        /// From SIMS ID
        /// </summary>
        public string Client_ID { get; set; }
        /// <summary>
        /// For each school you get a client id and a secret
        /// From SIMS ID
        /// </summary>
        public string Secret { get; set; }
        /// <summary>
        /// Each school has an org id
        /// From SIMS ID
        /// </summary>
        public string Organisation_ID { get; set; }
        /// <summary>
        /// The scopes define access required
        /// e.g. partnerserverapplication partner
        /// </summary>
        public string Scopes { get; set; }
        /// <summary>
        /// The OCP APIM Key - one key per vendor possibly per app.
        /// From partner support
        /// </summary>
        public string OCP_APIM_Key { get; set; }
        /// <summary>
        /// OCP_APIM_Key for V2
        /// </summary>
        public string OCP_APIM_KeyV2 { get; set; }

    }
    public class BearerToken
    {
        public string Token = "";
        //int HttpCode = 500;
        public BearerToken(AuthRequest arq, HttpClient httpClient)
        {

            string grant_type = "client_credentials";
            string client_id = arq.Client_ID;
            string client_secret = arq.Secret;

            var form = new Dictionary<string, string>
                {
                    {"grant_type", grant_type},
                    {"client_id", client_id},
                    {"client_secret", client_secret},
                    { "scope", arq.Scopes },
                };
            if (arq.Organisation_ID != null)
            {
                form.Add("acr_values", "orgselected:" + arq.Organisation_ID);
            }
            var httpClientResponseTask = httpClient.PostAsync(arq.STS, new FormUrlEncodedContent(form));
            httpClientResponseTask.Wait();
            var result = httpClientResponseTask.Result;
            var responseStringTask = result.Content.ReadAsStringAsync();
            responseStringTask.Wait();
            //HttpCode = responseStringTask.Result.;
            string responseString = responseStringTask.Result;
            var jo2 = Newtonsoft.Json.JsonConvert.DeserializeObject(responseString);
            Newtonsoft.Json.Linq.JObject jo = Newtonsoft.Json.Linq.JObject.Parse(jo2.ToString());
            Token = (string)jo.SelectToken("access_token");
        }
    }
}
