﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Configuration;

namespace GetMyCreds
{
    public class Program
    {
        public class Customer
        {
            public int? Id;
            public string Name;
            public Guid? OrganisationId;
            public string DfeCode;
            public string DeniNumber;
            public int? Authorised;
            public Credential Credentials;
        }
        public class Credential
        {
            public string ClientId;
            public string Secret;
            public string OCPAIMKey;
            public string Description;
        }
        /// <summary>
        /// Get a Vendor Management token which allows the TI to return the schoosl using the requested app
        /// and subsequently enables requests to get the credentials for the APIs to get data from the school's system.
        /// </summary>
        /// <returns></returns>
        public static string VendorManagementToken()
        {
            AuthRequest arq = new AuthRequest();
            string rc = "";
            // warning - IF THESE KEYS AND SECRETS ARE LOST THEN A MALICIOUS ACTOR COULD ACCESS
            // DATA IN ALL OF YOUR SCHOOLS
            // We recommend Key Vault or similar to store these!
            arq.Client_ID = ConfigurationManager.AppSettings["ClientID"];
            arq.Secret = ConfigurationManager.AppSettings["Secret"];
            // WARNING
            arq.Organisation_ID = null;
            arq.STS = "https://sts.sims.co.uk/connect/token";
            // Note the different scopes.
            arq.Scopes = "partner-read partner-write";
            BearerToken bt = new BearerToken(arq, httpClient);
            rc = bt.Token;
            return rc;
        }
        /// <summary>
        /// Gets a token for RAP / One Roster or DeX  -
        /// 
        /// </summary>
        /// <param name="clientId"></param>
        /// <param name="secret"></param>
        /// <param name="scopes">Scopes need to reflect the call requested.</param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static string SchoolDataAccessToken(string clientId, string secret, string scopes, string orgId)
        {
            AuthRequest arq = new AuthRequest();
            string rc = "";
            arq.Client_ID = clientId;
            arq.Secret = secret;
            arq.Organisation_ID = orgId; // Must have one
            arq.STS = "https://sts.sims.co.uk/connect/token";
            arq.Scopes = scopes;
            BearerToken bt = new BearerToken(arq, httpClient);
            rc = bt.Token;
            return rc;
        }
        /// <summary>
        ///  API Manager key is needed to access DeX endpoints - a sample value is below which will be throttled.
        /// </summary>
        public static string OCP_Key = "NOT Required";
        /// <summary>
        /// 
        /// This can be accessed via the SIMS UI - Edit the application in SIMS ID
        /// Look at the URL 
        /// https://ti.sims.co.uk/Applications/ManageApplication?applicationId=2585d852-956b-457d-b510-03584a3f02bf&siteId=18996
        /// and extract the applicationId like in the example above.
        /// 
        /// </summary>
        public static string ApplicationID = ConfigurationManager.AppSettings["ApplicationID"];
        public static CallInfo callInfo = new CallInfo();
        public static HttpClient httpClient = new HttpClient();
        public class CustomerInfo
        {
            public Customer customer { get; set; }
            public List<Credential> credentials { get; set; }
        }
        public static List<CustomerInfo> CustomerList = new List<CustomerInfo>();
        static void Main(string[] args)
        {
            // Get the vendo management token
            string token = VendorManagementToken();
            // Use it to get a list of schools using the requested app.
            Call c = new Call(string.Format("https://rap.sims.co.uk/api/v1/partner/{0}/GetSiteByApplication", ApplicationID));
            string resp = c.Execute(token, httpClient, "");
            // Create a list of customers (schools)
            var _Customers = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Customer>>(resp);
            // for each school - see what credentials are available.
            foreach (Customer cus in _Customers)
            {
                CustomerInfo customerInfo = new CustomerInfo();
                customerInfo.customer = cus;

                // Request for all of the available credentials for the app for the designated school
                Call c2 = new Call(string.Format("https://rap.sims.co.uk/api/v1/partner/{0}/{1}/Clients",
                                            ApplicationID, cus.OrganisationId));
                string resp2 = c2.Execute(token, httpClient, "");
                // Get a list of the credentials
                var _Credential = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Credential>>(resp2);

                // Many applications may need to get a pair of tokens, one for RAP/OneRoster and one for DeX
                Dictionary<string, string> ThisSchoolsTokens = new Dictionary<string, string>();
                customerInfo.credentials = _Credential;
                // For each of these get some data
                CustomerList.Add(customerInfo);
            }
            string output = Newtonsoft.Json.JsonConvert.SerializeObject(CustomerList);
            using (StreamWriter sw = new StreamWriter(ConfigurationManager.AppSettings["Output"]))
            {
                sw.Write(output);
                sw.Flush();
                sw.Close();

            }
        }
    }
}
