﻿// (c) Capita PLC 2020 All rights reserved unless stated below
// Capita grants access to use this code (or parts thereof) to the development community for not for profit activities.
// Capita grants access to use parts of the code to Capita SIMS Technical Integrators to include within their 
// applications with the inclusion of the wording:
//
// Parts (c) Capita PLC 2020 All Rights Reserved.
//
// This code intended as sample code for teaching purposes.
//
// Capita offers absolutely no warranty on this code, nor does Capita accept 
// any liability for the use, suitability or operation of the application or parts thereof. 

using System;
using System.IO;
using System.Diagnostics;

namespace PostitCommon
{
    public class Log
    {
        /// <summary>
        /// Set the location of the log file before use!
        /// </summary>
        public static string LogFile = "";
        public static bool DebugState = false;
        public static void Debug(string Message)
        {
            if (DebugState)
            {
                Write("<Verbose> " + Message);
            }
        }
        /// <summary>
        /// Write a message to the log file.
        /// </summary>
        /// <param name="Message"></param>
        public static void Write(string Message)
        {
            if (!string.IsNullOrEmpty(LogFile))
            {
                FileInfo fi = new FileInfo(LogFile);
                if (!fi.Directory.Exists)
                {
                    fi.Directory.Create();
                }
                using (StreamWriter sw = new StreamWriter(LogFile, true))
                {
                    sw.WriteLine(DateTime.Now.ToShortDateString() + "\t" + DateTime.Now.ToShortTimeString() + "\t" + Environment.UserDomainName + "\\" + Environment.UserName + "\t" + Message);
                    sw.Flush();
                    sw.Close();
                }
            }
            else
            {
                throw new ArgumentNullException("Must define the log file name before using it!");
            }
        }
        public static void Show()
        {
            Process p = new Process();
            p.StartInfo.FileName = "Notepad";
            p.StartInfo.Arguments = LogFile;
            p.StartInfo.ErrorDialog = false;
            p.Start();
        }
    }
}
