﻿// (c) Capita PLC 2020 All rights reserved unless stated below
// Capita grants access to use this code (or parts thereof) to the development community for not for profit activities.
// Capita grants access to use parts of the code to Capita SIMS Technical Integrators to include within their 
// applications with the inclusion of the wording:
//
// Parts (c) Capita PLC 2020 All Rights Reserved.
//
// This code intended as sample code for teaching purposes.
//
// Capita offers absolutely no warranty on this code, nor does Capita accept 
// any liability for the use, suitability or operation of the application or parts thereof. 

namespace PostitCommon
{
    public class AuthRequest
    {
        /// <summary>
        /// Token server address
        /// partner support to provide
        /// </summary>
        public string STS { get; set; }
        /// <summary>
        /// For each school you get a client id and a secret
        /// From SIMS ID
        /// </summary>
        public string Client_ID { get; set; }
        /// <summary>
        /// For each school you get a client id and a secret
        /// From SIMS ID
        /// </summary>
        public string Secret { get; set; }
        /// <summary>
        /// Each school has an org id
        /// From SIMS ID
        /// </summary>
        public string Organisation_ID { get; set; }
        /// <summary>
        /// The scopes define access required
        /// e.g. partnerserverapplication partner
        /// </summary>
        public string Scopes { get; set; }
        /// <summary>
        /// The OCP APIM Key - one key per vendor possibly per app.
        /// From partner support
        /// </summary>
        public string OCP_APIM_Key { get; set; }

    }
}
