﻿// (c) Capita PLC 2020 All rights reserved unless stated below
// Capita grants access to use this code (or parts thereof) to the development community for not for profit activities.
// Capita grants access to use parts of the code to Capita SIMS Technical Integrators to include within their 
// applications with the inclusion of the wording:
//
// Parts (c) Capita PLC 2020 All Rights Reserved.
//
// This code intended as sample code for teaching purposes.
//
// Capita offers absolutely no warranty on this code, nor does Capita accept 
// any liability for the use, suitability or operation of the application or parts thereof. 

using System.Collections.Generic;
using System.Net.Http;



namespace PostitCommon
{
    public class BearerToken
    {
        public string Token = "";
        //int HttpCode = 500;
        public BearerToken(AuthRequest arq, HttpClient httpClient)
        {

            string grant_type = "client_credentials";
            string client_id = arq.Client_ID; 
            string client_secret = arq.Secret;

            var form = new Dictionary<string, string>
                {
                    {"grant_type", grant_type},
                    {"client_id", client_id},
                    {"client_secret", client_secret},
                    { "scope", arq.Scopes },
                    { "acr_values","orgselected:"+arq.Organisation_ID }
                };

            var httpClientResponseTask = httpClient.PostAsync(arq.STS, new FormUrlEncodedContent(form));
            httpClientResponseTask.Wait();
            var result = httpClientResponseTask.Result;
            var responseStringTask = result.Content.ReadAsStringAsync();
            responseStringTask.Wait();
            //HttpCode = responseStringTask.Result.;
            string responseString = responseStringTask.Result;
            var jo2 = Newtonsoft.Json.JsonConvert.DeserializeObject(responseString);
            Newtonsoft.Json.Linq.JObject jo = Newtonsoft.Json.Linq.JObject.Parse(jo2.ToString());
            Token = (string)jo.SelectToken("access_token");


            //Dictionary<string, string> JSONObj = (Dictionary<string, string>)Newtonsoft.Json.JsonConvert.DeserializeObject(responseString);
            //var JSONObj = new JavaScriptSerializer().Deserialize<Dictionary<string, string>>(responseString);
            //Token = JSONObj["access_token"];
        }
    }

}
