﻿using System;
using System.Net.Http;

namespace OneRosterRAPper
{
    class Program
    {
        static void Main(string[] args)
        {

            // Set up credentials within an auth request
            PostitCommon.Log.LogFile = @"c:\temp\Demo.log";
            PostitCommon.AuthRequest arq = new PostitCommon.AuthRequest();
            arq.Scopes = "onerosterapi organisation partner rapapi";
            arq.STS = "https://simsid-partner-stsserver.azurewebsites.net/connect/token";
            arq.OCP_APIM_Key = "Not Required";
            // Fill these in - partner.support@capita.co.uk can provide a copy and paste for this section
            arq.Client_ID = "sas-oneroster-... Ask Partner Support";
            arq.Organisation_ID =  "646A036F-Ask Partner Support";
            arq.Secret = "xKs-Ask Partner Support";
            // End of copy and paster

            
            ////Define and output folder
            string folder = @"c:\temp\rapor";
            // Get a token
            PostitCommon.BearerToken bt1 = new PostitCommon.BearerToken(arq, httpClient);
            if (!string.IsNullOrEmpty(bt1.Token))
            {
                // Get Rapping
                foreach (string s in new string[]{ "students","LearnerParent","Staff","Organisation"})
                {
                    Run("https://simsid-partner-rapapi.azurewebsites.net/api/v1/Organisation/" + arq.Organisation_ID + "/"+s+"/", bt1, arq.OCP_APIM_Key, "RAP"+s+".json", folder);
                }

                // Get One Rostering 
                foreach (string s in new string[] { "Teachers", "classes", "academicSessions", "categories" , "enrollments", "Gradingperiods", "Schools", "Students", "Terms", "Users"})
                {
                    Run("https://simsid-partner-oneroster.azurewebsites.net/ims/oneroster/v1p1/" + s + "/", bt1, arq.OCP_APIM_Key, "OR_" + s + ".json", folder);
                }
            }
        }
        /// <summary>
        /// One and one only http client for this application.
        /// </summary>
        static HttpClient httpClient = new HttpClient();
        /// <summary>
        /// Format and make the call.
        /// </summary>
        /// <param name="call"></param>
        /// <param name="bt1"></param>
        /// <param name="key"></param>
        /// <param name="file"></param>
        /// <param name="folder"></param>
        static void Run(string call, PostitCommon.BearerToken bt1,string key ,string file, string folder)
        {
            PostitCommon.Call c1 = new PostitCommon.Call(call);
            string resp = c1.Execute(bt1.Token, httpClient, key);
            PostitCore.Dump.ToFile(resp, file, folder);

        }
    }
}
