﻿// (c) Capita PLC 2020 All rights reserved unless stated below
// Capita grants access to use this code (or parts thereof) to the development community for not for profit activities.
// Capita grants access to use parts of the code to Capita SIMS Technical Integrators to include within their 
// applications with the inclusion of the wording:
//
// Parts (c) Capita PLC 2020 All Rights Reserved.
//
// This code intended as sample code for teaching purposes.
//
// Capita offers absolutely no warranty on this code, nor does Capita accept 
// any liability for the use, suitability or operation of the application or parts thereof. 

using System;

using System.Net.Http;
using System.Net.Http.Headers;
using System.Xml;
using System.IO;
//using System.Drawing.Common;

namespace PostitCommon
{
    public class Call
    {
        public string ErrorMessage = "";
        private string URL { get; set; }
        private string Name { get; set; }
        private string Content_type { get; set; }
        public Call(string Url)
        {
            URL = Url;
            Name = "Direct URL";
        }
        
        
        public string Execute(string BearerToken, HttpClient httpClient, string OCP_APIM_Key)
        {
            string rc = "";
            try
            {
                var request = new HttpRequestMessage()
                {
                    RequestUri = new Uri(URL),
                    Method = HttpMethod.Get,
                };
                if (Content_type != null && Content_type != "")
                {
                    request.Headers.Accept.Add(new MediaTypeWithQualityHeaderValue(Content_type));
                }
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", BearerToken);
                request.Headers.Add("Ocp-Apim-Subscription-Key", OCP_APIM_Key);
                var httpClientResponseTask = httpClient.SendAsync(request);
                httpClientResponseTask.Wait();
                var result = httpClientResponseTask.Result;
                var responseStringTask = result.Content.ReadAsStringAsync();
                rc = responseStringTask.Result.ToString();

            }

            catch (Exception ex)
            {

                ErrorMessage = ">>>>+" + Name + ": " + ex.Message;
                PostitCommon.Log.Write(ErrorMessage);
            }
            return rc;
        }

    }
}
