﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Xml;

namespace PartnerWorld
{
    public class AttendanceInterface
    {
        /// <summary>
        /// The partner system needs to control what's done
        /// </summary>
        public static DateTime AttendanceDate { get { return DateTime.Today.AddDays(14); } } // Warning avoid holidays
        public static string AttendanceCode = "/";  // Set a default 
        public static void SaveAttendanceData(XmlDocument d)
        {
            // TODO!
            return;
        }
        public static int StudentID = -1;
        /// <summary>
        /// The application needs to take out the student data that it is authorised to extract and store it appropriately.
        /// our example simply needs any valid student ID.
        /// </summary>
        /// <param name="d"></param>
        public static void SaveStudentData(XmlDocument d)
        {
            foreach (XmlNode n in d.SelectNodes("Students/Student") )
            {
                string sId = n["PersonID"].InnerXml;
                int i = 0;
                int.TryParse(sId, out i);
                StudentID = i;
                break;
            }
            // Simply pick the first student ID for our purposes
            return;
        }
        /// <summary>
        /// Save attendance codes shoudl do more but the example simply tries to pick a standard present code 
        /// if it fails, it picks the last code in the list for demo purposes
        /// </summary>
        /// <param name="d"></param>
        public static void SaveAttendanceMarks(XmlDocument d)
        {
            foreach (XmlNode n in d.SelectNodes("AttendanceCodes/AttendanceCode"))
            {
                string sCode = n["Code"].InnerXml;
                AttendanceCode = sCode;
                if (sCode == "\\")
                {
                    break;
                }
            }
            return;
            // Simply pick the first student ID for our purposes
            return;
        }
    }
}
