﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
namespace SIMSInterface
{
    public class MappingTable
    {
        
        private static Dictionary<Guid,int> reverseMappings = new Dictionary<Guid,int>();
        private static Dictionary<int, Guid> mappings = new Dictionary<int,Guid>();
        public MappingTable()
        {
            if (mappings.Count == 0)
            {
                SIMS.Processes.TPSIFSupport tpss = new SIMS.Processes.TPSIFSupport();
                XmlDocument map =  tpss.GetSifRefIdsAsXML();
                foreach (XmlNode n in map.SelectNodes("People/Person"))
                {
                    string x = n["ExternalID"].InnerXml;
                    string i = n["PersonID"].InnerXml;
                    mappings.Add(int.Parse(i), Guid.Parse(x));
                    reverseMappings.Add(Guid.Parse(x), int.Parse(i));
                }
            }
        }
        public Guid GetExternalId(int internalID)
        {

            Guid g = Guid.Empty;
            mappings.TryGetValue(internalID, out g);
            return g;
        }
        public int GetInternalID(Guid externalID)
        {
            int i = 0;
            reverseMappings.TryGetValue(externalID, out i);
            return i;
        }

    }
}
