﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------


using System;
using System.Xml;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace ReadAssessment
{
    class Program
    {
        private static string[] Args;
        /// <summary>
        /// Get the server
        /// </summary>
        private static string Server { get { return Args[0]; } }
        /// <summary>
        /// Get the database
        /// </summary>
        private static string Database { get { return Args[1]; } }
        /// <summary>
        /// Get the User
        /// </summary>
        private static string User { get { return Args[2]; } }
        /// <summary>
        /// Get the password
        /// </summary>
        private static string Password { get { return Args[3]; } }
        static void Main(string[] args)
        {
            Args = args;
            try
            {
                // SIMS DLLS ARE STRONG NAMED AND THE APPLICATION WILL FAIL WITHOUT THIS CALL
                SIMSInterface.SIMSDllResolution.AddSIMSDllResolution();
                // WARNING - DO NOT PUT ANY CODE IN THIS MAIN FUNCTION THAT RELIES UPON THE DLL RESOLUTION 
                // CALL OUT TO ANY OTHER FUNCTION
                AnyOtherFunction();
            }
            catch (Exception ex)
            {
                // Handle error 
                Console.WriteLine(ex.ToString());
            }
        }
        /// <summary>
        /// SIMS Calls can be made in any funciton except main
        /// </summary>
        static void AnyOtherFunction()
        {
            // Login
            if (SIMSInterface.LoginHelper.SIMSlogin(Server, Database, User, Password))
            {

                // Set Supplier
                SIMSInterface.Assessment.DefaultSource = "EDU365";
                // In order to write anything back, the user needs to create an Agency with
                // the same name as "Our Company" in SIMS.
                // This prevents random suppliers providing results to the school.

                // Get all Aspects
                string ErrorMessage = "";
                XmlDocument d = new XmlDocument();
                d = SIMSInterface.Assessment.GetAspects(ref ErrorMessage);
                d.Save(@"c:\temp\aspects.xml");
                // Grade sets
                d = SIMSInterface.Assessment.GetGradeSets(ref ErrorMessage);
                d.Save(@"c:\temp\gradesets.xml");
                //Result sets
                d = SIMSInterface.Assessment.GetResultSets(ref ErrorMessage);
                d.Save(@"c:\temp\Resultsets.xml");
                // WARNING
                // Not a good choice of result set id..to get any results
                // Must provide a student id, result set id or an aspect id (but only one of these)
                d = SIMSInterface.Assessment.GetResults(ref ErrorMessage, "", "", "86817FEDCC23413DBA9F634B73F0D518");
                d.Save(@"c:\temp\Results.xml");

            }
            else
            {
                Console.WriteLine(SIMSInterface.LoginHelper.ErrorMessage);
            }
            
        }
    }
}
