﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CoverApp
{
    public partial class CreateCover : Form
    {
        SIMS.Processes.CovDiary covDiary = new SIMS.Processes.CovDiary();
        SIMS.Processes.CovRegisterAbsence covRegister = new SIMS.Processes.CovRegisterAbsence();
        public CreateCover(SIMS.Processes.CovDiary cov)
        {
            InitializeComponent();
            covDiary = cov;
            dtStartDate.Format = DateTimePickerFormat.Custom;
            dtStartDate.CustomFormat = "dd/MM/yyyy HH:mm:ss";
            dtEndDate.Format = DateTimePickerFormat.Custom;
            dtEndDate.CustomFormat = "dd/MM/yyyy HH:mm:ss";
        }

        private void btnStaffCover_Click(object sender, EventArgs e)
        {
            saveAssinment();
        }
        
        private void saveAssinment()
        {
            // DateTime sould have correct time for Class Periods or else the Cover will display incorrectly
            DateTime start = dtStartDate.Value;
            DateTime end = dtEndDate.Value;
            int reason = -1;

            SIMS.Entities.InformationDomainEnum infodomain = SIMS.Entities.InformationDomainEnum.CoverCommon;
            SIMS.Entities.CovDiaryAbsenceClosure absenceClosure = new SIMS.Entities.CovDiaryAbsenceClosure(infodomain);
            SIMS.Entities.CovAbsenceReason abReason = new SIMS.Entities.CovAbsenceReason();
            SIMS.Entities.CovDiaryStaff selectedStaff = (SIMS.Entities.CovDiaryStaff)cbStaff.SelectedItem; // Sets Staff value to selected ComboBox

            covRegister.Load(start); // Loads Register again incase of date change
            covRegister.LoadPeriods(start);                                
            abReason = (SIMS.Entities.CovAbsenceReason)cbReason.SelectedItem;

            reason = abReason.ReasonID;

            absenceClosure.Resource.ID = selectedStaff.IDAttribute.Value;// staff id, drawn from combobox
            absenceClosure.ReasonId = reason; // reason for cover, drawn from combobox

            absenceClosure.StartDate = start;
            absenceClosure.EndDate = end;
            absenceClosure.ExtendAbsence = false; // is extended absence
            absenceClosure.ExternalID = ""; //autofilled

            covRegister.CovDiaryAbsenceClosures.Add(absenceClosure);
            covDiary.absenceXML = covRegister.GetSaveXML();

            covDiary.Save();

            string brake = "";

        }
              
        private void CreateCover_Load(object sender, EventArgs e)
        {
            covRegister.Load(DateTime.Now);
            foreach (SIMS.Entities.CovAbsenceReason absenceReason in covRegister.CovAbsenceReasons)
            {
                cbReason.Items.Add(absenceReason);
            }
            foreach(SIMS.Entities.CovDiaryStaff staff in covDiary.Staffs)
            {
                cbStaff.Items.Add(staff);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }



        private void closeRoom()
        {
            DateTime start = new DateTime(2018, 11, 14, 8, 45, 00);
            DateTime end = new DateTime(2018, 11, 14, 16, 00, 00);

            SIMS.Entities.CovDiaryAbsenceClosures closures = new SIMS.Entities.CovDiaryAbsenceClosures();
            SIMS.Entities.CovDiaryAbsenceClosure absenceClosure = new SIMS.Entities.CovDiaryAbsenceClosure(SIMS.Entities.InformationDomainEnum.CoverCommon);

            absenceClosure.Resource.ID = 25;//RoomID
            absenceClosure.ReasonId = 4;//Out of Service
            absenceClosure.StartDate = start;
            absenceClosure.EndDate = end;

            closures.Add(absenceClosure);
            covDiary.closureXML = closures.GetSaveXML();

            covDiary.Save();

        }

        private void btnRoomClose_Click(object sender, EventArgs e)
        {
            closeRoom();
        }

    }
}
