﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CoverApp
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        
        private void buttonLogin_Click(object sender, EventArgs e)
        {
            DateTime filter = DateTime.Now.Date;
            int filCurYear = Convert.ToInt32(filter.Year);
            int filNextYear = filCurYear + 1;

            if (SIMSCoverLibrary.LoginHelper.SIMSlogin(Server,Database,User,Password))
            {
                groupBoxLogin.Enabled = false;
                cbACYear.Items.Clear();
                List<string> ay = SIMSCoverLibrary.Cover.AcademicYears();

                //Gets only Last, Current and Next Year Groupings
                foreach (string y in ay)
                {
                    if(y.Contains(Convert.ToString((filCurYear))) ||y.Contains(Convert.ToString(filNextYear)))
                    {
                        cbACYear.Items.Add(y);
                    }
                }
                groupBoxCover.Enabled = true;
            }
        }
        /// <summary>
        /// SIMS Server
        /// </summary>
        public string Server { get { return textBoxSIMSServer.Text; } }
        /// <summary>
        /// SIMS Database
        /// </summary>
        public string Database { get { return textBoxSIMSDatabase.Text; } }
        /// <summary>
        /// SIMS User
        /// </summary>
        public string User { get { return textBoxSIMSUser.Text; } }
        /// <summary>
        /// SIMS Password
        /// </summary>
        public string Password { get { return textBoxSIMSPassword.Text; } }

        private void buttonDisplayCover_Click(object sender, EventArgs e)
        {
            checkedListBoxCovers.Items.Clear();
            checkedListBoxReason.Items.Clear();
            checkedListBoxRoom.Items.Clear();
            checkedListBoxStaff.Items.Clear();
            // Load the covers for that day;

            foreach(SIMSCoverLibrary.Cover.CoverActivity activity in SIMSCoverLibrary.Cover.GetCoverDiary((string)cbACYear.SelectedItem, dtCoverDate.Value))
            {
                if (activity.conflickExisted == true)
                {
                    MessageBox.Show("A conflict existed in the Cover Diary and has been resolved");
                }
                checkedListBoxCovers.Items.Add(activity);
            }
            foreach(SIMSCoverLibrary.Cover.Staff staff in SIMSCoverLibrary.Cover.GetAllStaffs())
            {
                checkedListBoxStaff.Items.Add(staff);
            }
            foreach (SIMSCoverLibrary.Cover.Reason reason in SIMSCoverLibrary.Cover.GetStaffReasons())
            {
                checkedListBoxReason.Items.Add(reason);
            }
            foreach (SIMSCoverLibrary.Cover.Room Room in SIMSCoverLibrary.Cover.getAllRooms())
            {
                checkedListBoxRoom.Items.Add(Room);
            }
        }

        private void UpdateStaff(object sender, EventArgs e)
        {
            checkedListBoxStaff.Items.Clear();

            foreach (SIMSCoverLibrary.Cover.Staff staff in SIMSCoverLibrary.Cover.GetStaffForCover((SIMSCoverLibrary.Cover.CoverActivity)checkedListBoxCovers.SelectedItem))
            {
                checkedListBoxStaff.Items.Add(staff);
            }
        }

        private void AllowCover(object sender, EventArgs e)
        {
            buttonDisplayCover.Enabled = true;
        }

        private void buttonAddRoomClose_Click(object sender, EventArgs e)
        {
            if (checkedListBoxReason.CheckedItems.Count > 0 && checkedListBoxRoom.CheckedItems.Count > 0)
            {
                SIMSCoverLibrary.Cover.closeRoom((SIMSCoverLibrary.Cover.Room)checkedListBoxRoom.CheckedItems[0], (SIMSCoverLibrary.Cover.Reason)checkedListBoxReason.CheckedItems[0], dtCoverDate.Value);

                MessageBox.Show("Room Cover Created");
            }
            else
            {
                MessageBox.Show("Please Select a Room and Reason");
            }
            refreshAllgroups();
        }

        private void buttonAssignStaff_Click(object sender, EventArgs e)
        {
            if (checkedListBoxCovers.CheckedItems.Count > 0 && checkedListBoxStaff.CheckedItems.Count > 0)
            {
                SIMSCoverLibrary.Cover.assignStaff((SIMSCoverLibrary.Cover.CoverActivity)checkedListBoxCovers.CheckedItems[0], (SIMSCoverLibrary.Cover.Staff)checkedListBoxStaff.CheckedItems[0]);
                MessageBox.Show("Staff Assigned");
            }
            else
            {
                MessageBox.Show("Please Select a Cover Period and Staff");
            }
            refreshAllgroups();
        }

        private void buttonAddCover_Click(object sender, EventArgs e)
        {
            if (checkedListBoxStaff.CheckedItems.Count > 0 && checkedListBoxReason.CheckedItems.Count > 0)
            {
                SIMSCoverLibrary.Cover.createCover(((SIMSCoverLibrary.Cover.Staff)checkedListBoxStaff.CheckedItems[0]),(SIMSCoverLibrary.Cover.Reason)checkedListBoxReason.CheckedItems[0], dtCoverDate.Value);
                MessageBox.Show("Cover Created");
            }
            else
            {
                MessageBox.Show("Please Select a Staff and Reason");
            }
            refreshAllgroups();
        }

        private void checkedListBoxRoom_SelectedIndexChanged(object sender, EventArgs e)
        {
            checkedListBoxReason.Items.Clear();
            foreach (SIMSCoverLibrary.Cover.Reason reason in SIMSCoverLibrary.Cover.GetRoomReasons(dtCoverDate.Value))
            {
                checkedListBoxReason.Items.Add(reason);
            }
        }

        private void checkedListBoxStaff_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            checkedListBoxReason.Items.Clear();
            foreach (SIMSCoverLibrary.Cover.Reason reason in SIMSCoverLibrary.Cover.GetStaffReasons())
            {
                checkedListBoxReason.Items.Add(reason);
            }
        }

        private void buttonRefreash_Click(object sender, EventArgs e)
        {
            refreshAllgroups();
        }

        public void refreshAllgroups()
        {
            checkedListBoxCovers.Items.Clear();
            checkedListBoxReason.Items.Clear();
            checkedListBoxRoom.Items.Clear();
            checkedListBoxStaff.Items.Clear();
            foreach (SIMSCoverLibrary.Cover.CoverActivity activity in SIMSCoverLibrary.Cover.GetCoverDiary((string)cbACYear.SelectedItem, dtCoverDate.Value))
            {
                if(activity.conflickExisted == true)
                {
                    MessageBox.Show("A conflict existed in the Cover Diary and has been resolved");
                }
                checkedListBoxCovers.Items.Add(activity);
            }
            foreach (SIMSCoverLibrary.Cover.Staff staff in SIMSCoverLibrary.Cover.GetAllStaffs())
            {
                checkedListBoxStaff.Items.Add(staff);
            }
            foreach (SIMSCoverLibrary.Cover.Reason reason in SIMSCoverLibrary.Cover.GetStaffReasons())
            {
                checkedListBoxReason.Items.Add(reason);
            }
            foreach (SIMSCoverLibrary.Cover.Room Room in SIMSCoverLibrary.Cover.getAllRooms())
            {
                checkedListBoxRoom.Items.Add(Room);
            }
        }
    }
}
