﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;
namespace CoverApp
{
    public partial class Diary : Form
    {

        
        public Diary()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            XmlDocument d =  SIMSCoverLibrary.Cover.GetCoverDiary(cbACYear.SelectedItem.ToString(), dtCoverDate.Value);
           // lvCover.Clear();
            getCover();
            btnCover.Enabled = true;
            //lvCover.Refresh();
            btnAssign.Enabled = true;
        }

        private void getCover()
        {
            coverDiaryBrowse.LoadCoverSummary((SIMS.Entities.CovAcadYear)cbACYear.SelectedItem, dtCoverDate.Value, 1, true);
            covDiary.LoadCoverDiary(dtCoverDate.Value);

            foreach (SIMS.Entities.CovDiaryDayActivity dayActivity in covDiary.DayDiary.DayActivities)
            {
                ListViewItem lvi = new ListViewItem();
                lvi.Text = dayActivity.Resource.Description;

                if (dayActivity.Activities.Count > 0)
                {

                    lvi.SubItems.Add(dayActivity.UnavailabilityAttribute[0].ReasonDescription);

                    foreach (SIMS.Entities.CovDiaryActivity cov in dayActivity.Activities)
                    {

                        foreach (SIMS.Entities.CovDiaryAssignment diaryAssignment in cov.Assignments)
                        {
                            if (diaryAssignment.CoverResource != null)
                            {
                                lvi.SubItems.Add(diaryAssignment.CoverResource.Description +  " : " + diaryAssignment.StartTime);
                            }
                        }
                    }
                }

                lvCover.Items.Add(lvi);
            }

            lvCover.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent);
        }

        private void Cover_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < coverDiaryBrowse.AcademicYearList.Count; i++)
            {
                cbACYear.Items.Add(coverDiaryBrowse.AcademicYearList[i]);
            }
        }

        private void btExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            CreateCover createCover = new CreateCover(covDiary);
            createCover.Show();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            AssignStaff assignStaff = new AssignStaff(covDiary);
            assignStaff.Show();
        }

        private void cbACYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            btnDiary.Enabled = true;
        }

        private void dtCoverDate_ValueChanged(object sender, EventArgs e)
        {

        }
    }
}
