﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.IO;

namespace SIMSCoverLibrary
{
    /// <summary>
    /// A variant of the DLL resolution code from the plugins.  In this case it strictly uses the SIMS .Net folder as the source of SIMS DLLs
    /// </summary>
    public class SIMSDllResolution
    {
        static int resolverCount = 0;
        /// <summary>
        /// Make this function call from Main before much else is done.
        /// </summary>
        public static void AddSIMSDllResolution()
        {
            #region AL get the sims .net assemblies
            if (resolverCount == 0)
            {
                AppDomain currentDomain = AppDomain.CurrentDomain;
                currentDomain.AssemblyResolve += currentDomain_AssemblyResolve;
                resolverCount++;
            }
            #endregion

        }

        #region AL get the sims .net assemblies
        private static Assembly currentDomain_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            //This handler is called only when the common language runtime tries to bind to the assembly and fails.

            //Retrieve the list of referenced assemblies in an array of AssemblyName.
            string strTempAssmbPath = string.Empty;
            string assemblyBeingResolved = args.Name.Substring(0, args.Name.IndexOf(","));

            Assembly objExecutingAssemblies = Assembly.GetExecutingAssembly();
            AssemblyName[] arrReferencedAssmbNames = objExecutingAssemblies.GetReferencedAssemblies();

            //Loop through the array of referenced assembly names.
            if (arrReferencedAssmbNames.Any(strAssmbName => strAssmbName.FullName.Substring(0, strAssmbName.FullName.IndexOf(",")) == assemblyBeingResolved))
            {
                strTempAssmbPath = assemblyPath(assemblyBeingResolved + ".dll");
            }
            Assembly MyAssembly = null;
            //Load the assembly from the specified path. 					
            if (!string.IsNullOrEmpty(strTempAssmbPath))
            {
                MyAssembly = Assembly.LoadFrom(strTempAssmbPath);
            }
            else
            {
                string path = assemblyPath(assemblyBeingResolved + ".dll");
                if (!String.IsNullOrEmpty(path))
                    MyAssembly = Assembly.LoadFrom(path);
            }
            //Return the loaded assembly.
            return MyAssembly;
        }

        private static string assemblyPath(string assemblyFileName)
        {
            string rc = string.Empty;
            string assemblyPathLocal = Path.Combine(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location), assemblyFileName);


            if (File.Exists(assemblyPathLocal))
                rc = assemblyPathLocal;
            else
            {
                assemblyPathLocal = Path.Combine(SIMSLocation.SIMSDotNetDirectory, assemblyFileName);

                if (File.Exists(assemblyPathLocal))
                {
                    rc = assemblyPathLocal;
                }
                else
                {
                    assemblyPathLocal = Path.Combine(Environment.CurrentDirectory, assemblyFileName);
                    if (File.Exists(assemblyPathLocal))
                    {
                        rc = assemblyPathLocal;
                    }
                }
            }

            return rc;
        }
        #endregion
    }
}
