﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using SIMS.Entities;
using SIMS.Processes;

namespace SIMSCoverLibrary
{
   
    public class Cover
    {
        private static SIMS.Processes.CoverDiaryBrowse coverDiaryBrowse = new SIMS.Processes.CoverDiaryBrowse();
        private static SIMS.Processes.CovDiary covDiary = new SIMS.Processes.CovDiary();
        private static SIMS.Processes.CovRegisterAbsence covRegister = new SIMS.Processes.CovRegisterAbsence();
        SIMS.Entities.CovDiaryAbsenceClosure absenceClosure;

        #region Read Requests
        public static List<string> AcademicYears()
        {
            List<string> yrs = new List<string>();
            foreach (SIMS.Entities.CovAcadYear y in SIMS.Entities.CovCache.AcadYears)
            {
                yrs.Add(y.Description);
            }
            return yrs;

        }
        public static List<Staff> GetAllStaffs()
        {
            List<Staff> allStaff = new List<Staff>();
            foreach (SIMS.Entities.CovDiaryStaff S in covDiary.Staffs)
            {
                allStaff.Add(new Staff(S.ID, S.Description));
            }
            return allStaff;

        }
        public static List<Room> getAllRooms()
        {
            List<Room> allRoom = new List<Room>();
            foreach (SIMS.Entities.CovDiaryRoom R in covDiary.Rooms)
            {
                allRoom.Add(new Room(R.ID, R.Description));
            }
            return allRoom;
        }
        public static List<Reason> GetStaffReasons()
        {
            List<Reason> allReasons = new List<Reason>();
            foreach (SIMS.Entities.CovAbsenceReason R in covRegister.CovAbsenceReasons)
            {
                allReasons.Add(new Reason(R.ReasonID, R.ReasonDescription));
            }
            return allReasons;
        }
        public static List<Reason> GetRoomReasons(DateTime date)
        {
            List<Reason> allReasons = new List<Reason>();
            SIMS.Entities.CovClosureReasons covClosureReasons = new CovClosureReasons();
            SIMS.Processes.CovRegisterClosure registerClosure = new CovRegisterClosure();
            SIMS.Entities.DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(InformationDomainEnum.CoverCommon);
    
            registerClosure.Load(dateTimeAttribute);

            foreach (SIMS.Entities.CovClosureReason R in registerClosure.ClosureReasons.Value)
            {
                allReasons.Add(new Reason(R.ReasonID, R.ReasonDescription));
            }
            return allReasons;
        }
        public static List<CoverActivity> GetCoverDiary(string year, DateTime date)
        {
            bool tempConflict = false;
            int iteration = 0;
            List<CoverActivity> activities = new List<CoverActivity>();
            SIMS.Processes.CovCache c = new SIMS.Processes.CovCache();
            CovAcadYear _year = null;
            foreach (CovAcadYear y in SIMS.Entities.CovCache.AcadYears)
            {
                if (y.Description == year)
                {
                    _year = y;
                    break;
                }
            }
            coverDiaryBrowse.LoadCoverSummary(_year, date, 1, true);
            covDiary.LoadCoverDiary(date);
            covRegister.Load(date);//Loads CoverRegister for Absance reasons
            
            if(covDiary.TimetableChangeHostedProcess.ConflictsExist)// Reloads covDiary if there was a confict Message, should change method to return the confict then reload.
            {
                tempConflict = true;
                covDiary.LoadCoverDiary(date);
                covDiary.SyncTimetableChanges(date);

            }

            


            foreach (SIMS.Entities.CovDiaryDayActivity dayActivity in covDiary.DayDiary.DayActivities)//This is the Covers on a given day
            {
                CoverItem cover = new CoverItem();
                cover.StaffName = dayActivity.Resource.Description;

                if (dayActivity.UnavailabilityAttribute.Count > 0)
                {
                    cover.Reason = dayActivity.UnavailabilityAttribute[0].ReasonDescription;
                    Console.WriteLine(dayActivity.UnavailabilityAttribute[0].StartDate + " / " + dayActivity.UnavailabilityAttribute[0].EndDate);
                }
                else
                {

                }
                cover.StaffCode = dayActivity.Resource.Code;

                foreach (SIMS.Entities.CovDiaryActivity cov in dayActivity.Activities)// This is a Cover Period
                {
                    cover.CoverItemID = cov.ID;

                    foreach (SIMS.Entities.CovDiaryAssignment diaryAssignment in cov.Assignments)// This is the details of a Cover Period
                    {
                        CoverActivity ca = new CoverActivity();

                        ca.PeriodID = diaryAssignment.ClassPeriodID;
                        ca.Period = Convert.ToString(diaryAssignment.StartTime.TimeOfDay);
                        ca.CoverActivityID = diaryAssignment.ID;
                        ca.FromStaffID = diaryAssignment.PersonId;
                        ca.FromStaffCode = dayActivity.Resource.Code;
                        ca.RoomID = diaryAssignment.RoomId;
                        if (diaryAssignment.CoverResource != null)
                        {
                            ca.ToStaffCode = diaryAssignment.CoverResource.Code;
                        }
                        else
                        {
                            ca.ToStaffCode = "Required";
                        }
                        cover.activities.Add(ca.CoverActivityID,ca);                          
                        if(tempConflict == true && iteration == 0)
                        {
                            ca.conflickExisted = true;
                        }

                        activities.Add(ca);
                        iteration++;
                    }                   
                }
            }

            return activities;

        }
        public static List<Staff> GetStaffForCover(CoverActivity coverActivity)
        {
            List<Staff> l = new List<Staff>();
            SIMS.Entities.CovDiaryBaseResource covDiaryBase = null;
            SIMS.Entities.CovDiaryBaseResources covDiaryBases = null;
            
            foreach (SIMS.Entities.CovDiaryDayActivity dayActivity in covDiary.DayDiary.DayActivities)//This is the Covers on a given day
            {
                if(coverActivity.FromStaffCode == dayActivity.Resource.Code)
                {
                    foreach (SIMS.Entities.CovDiaryActivity cov in dayActivity.Activities)// This is a Cover Period
                    {
                        if (coverActivity.PeriodID == cov.ClassPeriodId)
                        {
                            foreach (SIMS.Entities.CovDiaryAssignment diaryAssignment in cov.Assignments)// This is the details of a Cover Period
                            {
                                covDiaryBases = covDiary.GetPrioritizedResources(diaryAssignment, cov, true, true, false, covDiaryBase, false);
                                break;
                            }
                        }

                    }
                }
            }
            foreach (SIMS.Entities.CovDiaryBaseResource baseResource in covDiaryBases)
            {
                l.Add(new Staff(baseResource.ID,baseResource.Description));
            }
            return l;
        }
        #endregion

        #region WriteBack
        public static void assignStaff(CoverActivity coverActivity, Staff selectedStaff)
        {
            SIMS.Entities.CovDiaryAssignments diaryAssignments = null;
            SIMS.Entities.CovDiaryActivitys diaryActivitys = null;
            SIMS.Entities.CovDiaryBaseResource covDiaryBase = null;
            
            foreach(SIMS.Entities.CovDiaryStaff covStaff in covDiary.Staffs)
            {
                if(covStaff.ID == selectedStaff.StaffId)
                {
                    covDiaryBase = covStaff;
                }
            }

            foreach (SIMS.Entities.CovDiaryDayActivity dayActivity in covDiary.DayDiary.DayActivities)//This is the Covers on a given day
            {
                if (coverActivity.FromStaffCode == dayActivity.Resource.Code)
                {
                    foreach (SIMS.Entities.CovDiaryActivity cov in dayActivity.Activities)// This is a Cover Period
                    {
                        if (coverActivity.PeriodID == cov.ClassPeriodId)
                        {
                            foreach (SIMS.Entities.CovDiaryAssignment diaryAssignment in cov.Assignments)// This is the details of a Cover Period
                            {
                                covDiary.AssignResource(diaryAssignment, cov, covDiaryBase, out diaryActivitys, out diaryAssignments);
                                covDiary.Save();
                                break;
                            }
                            break;
                        }
                    }
                    break;
                }
            }
        }
        public static void closeRoom(Room roomToClose, Reason colsureReason, DateTime date)
        {
            date = date.Date;//Zeros the time for use
            DateTime end = date.AddHours(16.0);
            DateTime start = date.AddHours(8.75);

            SIMS.Entities.CovDiaryAbsenceClosures closures = new SIMS.Entities.CovDiaryAbsenceClosures();
            SIMS.Entities.CovDiaryAbsenceClosure absenceClosure = new SIMS.Entities.CovDiaryAbsenceClosure(SIMS.Entities.InformationDomainEnum.CoverCommon);


            absenceClosure.Resource.ID = roomToClose.RoomID;//RoomID
            absenceClosure.ReasonId = colsureReason.ReasonId;
            absenceClosure.StartDate = start;
            absenceClosure.EndDate = end;

            closures.Add(absenceClosure);
            covDiary.closureXML = closures.GetSaveXML();

            covDiary.Save();
        }
        public static void createCover(Staff selectedStaff, Reason selectedReason,DateTime date)
        {
            // DateTime sould have correct time for Class Periods or else the Cover will display incorrectly
            date = date.Date;//Zeros the time for use
            DateTime end = date.AddHours(16.0); 
            DateTime start = date.AddHours(8.75);

            SIMS.Entities.InformationDomainEnum infodomain = SIMS.Entities.InformationDomainEnum.CoverCommon;
            SIMS.Entities.CovDiaryAbsenceClosure absenceClosure = new SIMS.Entities.CovDiaryAbsenceClosure(infodomain);

            absenceClosure.Resource.ID = selectedStaff.StaffId;// staff id, drawn from combobox
            absenceClosure.ReasonId = selectedReason.ReasonId; // reason for cover, drawn from combobox

            absenceClosure.StartDate = start;
            absenceClosure.EndDate = end;
            absenceClosure.ExtendAbsence = false; // is extended absence
            absenceClosure.ExternalID = ""; //autofilled

            covRegister.CovDiaryAbsenceClosures.Add(absenceClosure);
            covDiary.absenceXML = covRegister.GetSaveXML();

            covDiary.Save();
        }
        #endregion

        #region Class Types

        public class CoverItem
        {
            public int CoverItemID;
            public string StaffName;
            public string StaffCode;
            public int StaffId;
            public string Reason;
            public Dictionary<int, CoverActivity> activities = new Dictionary<int, CoverActivity>();
            public override string ToString()
            {
                return StaffName + "(" + StaffCode + ") " + Reason;
            }
        }
        public class CoverActivity
        {
            public int CoverActivityID;
            public string Period;
            public int PeriodID;
            public string FromStaffCode;
            public string ToStaffCode;
            public int FromStaffID;
            public int ToStaffID;
            public string RoomName;
            public int RoomID;
            public string CoverType;
            public bool conflickExisted;
            public override string ToString()
            {
                return Period + " : " + FromStaffCode + " : " + ToStaffCode;
            }
        }
        public class Staff
        {
            public int StaffId;
            public string Name;
            public Staff(int _id, string _Name)
            {
                StaffId = _id;
                Name = _Name;
            }
            public override string ToString()
            {
                return Name;
            }

        }
        public class Reason
        {
            public int ReasonId;
            public string ReasonDescription;
            public Reason(int _id, string _Name)
            {
                ReasonId = _id;
                ReasonDescription = _Name;
            }
            public override string ToString()
            {
                return ReasonDescription;
            }

        }
        public class Room
        {
            public int RoomID;
            public string RoomDescription;
            public Room(int _id, string _Name)
            {
                RoomID = _id;
                RoomDescription = _Name;
            }
            public override string ToString()
            {
                return RoomDescription;
            }

        }
        #endregion
    }
}
