﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSReporting
{
    class Program
    {
        private static string[] Args;
        private static string Server { get { return Args[0]; } }
        private static string Database { get { return Args[1]; } }
        private static string Password { get { return Args[3]; } }
        private static string User { get { return Args[2]; } }
        private static string FileName { get { return Args[4]; } }

        private static string ReportName { get { return Args[5]; } }

        static void Main(string[] args)
        {
            Args = args;
            if (args.Length < 5)
            {
                Console.WriteLine("Report Automation Example (c) Education Software Solutions 2021");
                Console.WriteLine("");
                Console.WriteLine("Parameters");
                Console.WriteLine("  Server Name");
                Console.WriteLine("  Database Name");
                Console.WriteLine("  SIMS User Name");
                Console.WriteLine("  SIMS Password or <Ignore> if current Windows (tm) user");
                Console.WriteLine("  Filename of the report definition file containing the report");
                Console.WriteLine("  Report Name to run");

                Console.WriteLine("");
                Console.WriteLine("Utilisation");
                Console.WriteLine("  By utilising this code sample or similar to automate the extraction of data from SIMS,");
                Console.WriteLine("  Technical Integrators (TI) will be liable to per-site charges as per www.capita-sims.co.uk");
                Console.WriteLine("  (follow to become a TI and the guidance available)");
                Console.WriteLine("");
                Console.WriteLine(@"  Outputs to c:\temp\<report name>.xml");

                Console.WriteLine("");
                Console.ReadKey();


                return;

            }
            string OutputFolder = @"c:\temp";
            if (SIMSReportingEngine.ReportingEngine.Load(FileName, Server, Database, User, Password))
            {
                System.Xml.XmlDocument d = SIMSReportingEngine.ReportingEngine.Run(ReportName, Server, Database, User, Password);
                if (!System.IO.Directory.Exists(OutputFolder))
                {
                    System.IO.Directory.CreateDirectory(OutputFolder);
                }
                d.Save(System.IO.Path.Combine(OutputFolder, ReportName + ".xml"));
            }
            else
            {
                Console.WriteLine(SIMSReportingEngine.ReportingEngine.ErrorMessage);
                Console.ReadKey();

            }
        }
    }
}
