﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class Commslog
    {
        public void PostComms(int applicantId)
        {

            SIMS.Processes.FeesStudentDetail feesStudentDetail = new SIMS.Processes.FeesStudentDetail();
            SIMS.Entities.Person app = new SIMS.Entities.Person(applicantId);
            feesStudentDetail.Populate(app);
            SIMS.Processes.Admissions.CommunicateeBrowse communicateeBrowse = new SIMS.Processes.Admissions.CommunicateeBrowse();
            SIMS.Processes.Admissions.CommunicationDetail communicationDetail = new SIMS.Processes.Admissions.CommunicationDetail();
            SIMS.Entities.Role role = new SIMS.Entities.Role("<Any>", 0);
            SIMS.Entities.Roles roles = new SIMS.Entities.Roles();



            role.RoleBit = communicateeBrowse.Roles.AggregateRole;
            communicateeBrowse.Search("", "", role);



            communicationDetail.Communication = feesStudentDetail.CreateCommunication(communicateeBrowse.Results[0]);



            SIMS.Entities.Admissions.CommunicationTypes communicationTypes = new SIMS.Entities.Admissions.CommunicationTypes();
            SIMS.Processes.Admissions.AdmissionSetup admissionSetup = new SIMS.Processes.Admissions.AdmissionSetup();
            admissionSetup.LoadRASetupDetails();
            communicationDetail.GetCommunicationTypes();



            communicationTypes = (SIMS.Entities.Admissions.CommunicationTypes)communicationDetail.GetCommunicationTypes();



            foreach (SIMS.Entities.Admissions.CommunicationType type in communicationTypes)
            {
                if (type.Description == "Email")
                {
                    communicationDetail.Communication.Type = type;
                    break;
                }
            }



            foreach (SIMS.Entities.Admissions.CommunicationPriority priority in communicationDetail.GetCommunicationPriorities())
            {
                if (priority.Description == "Low")
                {
                    communicationDetail.Communication.Priority = priority;
                    break;
                }
            }



            foreach (SIMS.Entities.Admissions.CommunicationContext context in communicationDetail.GetCommunicationContextCollection())
            {
                if (context.Description.Contains("Fees"))
                {
                    communicationDetail.Communication.Context = context;
                    break;
                }
            }



            foreach (SIMS.Entities.Admissions.CommunicationDirection direction in communicationDetail.GetCommunicationDirections())
            {
                if (direction.Description.Contains("Sent"))
                {
                    communicationDetail.Communication.Direction = direction;
                    break;
                }
            }



            foreach (SIMS.Entities.Admissions.CommunicationLogType logType in communicationDetail.GetCommunicationLogTypes())
            {
                if (logType.Description.Contains("Public"))
                {
                    communicationDetail.Communication.LogTypeAttribute.Value = logType;
                    break;
                }
            }



            if (communicationDetail.Valid())
            {
                communicationDetail.Save();
            }
            else
            {
                string errors = "Errors ";
                SIMS.Entities.ValidationErrors ve = new SIMS.Entities.ValidationErrors();
                communicationDetail.ValidationErrors(ve);



                foreach (SIMS.Entities.ValidationError v in ve)
                {
                    errors += " " + v.Message;
                }
                Console.WriteLine(errors);
            }
        }
    }
}
