﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class SimsPeople
    {
        public static List<SIMS.Entities.Role> Roles = new List<SIMS.Entities.Role>();
        static public MappingTable map = null;
        public Dictionary<int, CommonInterface.People> People = new Dictionary<int, CommonInterface.People>();
        public void Load()
        {
            CommonValues.Roles UsefulRoles = new CommonValues.Roles();
            if (map == null)
            {
                map = new MappingTable();
            }
            // Goes off to SIMS and loads a list of People
            SIMS.Processes.LookupCache.Populate();
            SIMS.Processes.PersonBrowse pb = new SIMS.Processes.PersonBrowse();
            foreach (SIMS.Entities.Role r in SIMS.Entities.LookupCache.Roles )
            {
                CommonInterface.Role UseThisRole = null;
                UsefulRoles.RoleValues.TryGetValue(r.Code, out UseThisRole);
                if (UseThisRole != null)
                {
                    pb.GetPersonsWithStaff("%", "%", r, DateTime.Now, false);
                    foreach (SIMS.Entities.PersonSummary p in pb.Persons)
                    {
                        CommonInterface.People peo = null;
                        People.TryGetValue(p.ID, out peo);

                        if (peo != null)
                        {
                            peo.Roles.Add(UseThisRole.Code, UseThisRole);
                        }
                        else
                        {
                            peo = new CommonInterface.People();
                            peo.Surname = p.Surname;
                            peo.Forename = p.Forename;
                            peo.ID = p.ID;
                            peo.ExternalID = map.GetExternalId(p.ID);
                            if (p.Title == null)
                            {
                                peo.Title = "";
                            }
                            else
                            {
                                peo.Title = p.Title.Description;
                            }
                            peo.Roles.Add(UseThisRole.Code, UseThisRole);
                            if (p.Gender != null)
                            {
                                peo.Gender = p.Gender.Description;
                            }
                            else
                            {
                                peo.Gender = "";
                            }
                                
                            People.Add(peo.ID, peo);
                            // Can't do addresses at present.

                        }
                    }
                
                }
            }

        }
       
    }
}
