﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using Newtonsoft.Json;
using System;
using System.IO;

namespace Applicant7Demo
{
    class Program
    {
        public static string Server = ".";
        public static string User = "BlackA";
        public static string Password = "abcd";
        public static string Database = "engga-s20";
        static void Main(string[] args)
        {
            SIMSInterface.SIMSDllResolution.AddSIMSDllResolution();
            Main2();
        }
        static void Main2()
        {
            string Error = "";

            if (!TestSerialization(out Error))
            {
                Console.WriteLine(Error);
            }
            if (!TestSIMSRead(out Error))
            {
                Console.WriteLine(Error);
            }


        }
        static bool TestSIMSRead(out string Error)
        {
            bool rc = false;
            Error = "";
            try
            {
                if (SIMSInterface.LoginHelper.SIMSlogin(Server, Database, User, Password))
                {
                    SIMSInterface.SimsPeople people = new SIMSInterface.SimsPeople();
                    people.Load();
                    string json = JsonConvert.SerializeObject(people.People, Formatting.Indented);
                    using (System.IO.StreamWriter sw = new System.IO.StreamWriter(@"c:\\temp\people.json"))
                    {
                        sw.Write(json);
                        sw.Flush();
                        sw.Close();
                    }

                }
            }
            catch (System.Exception ex)
            {
                Error = ex.ToString();
            }

            return rc;
        }
        /// <summary>
        /// Test of serialization
        /// </summary>
        static bool TestSerialization(out string Error)
        {
            bool rc = false;
            Error = "";
            try
            {
                CommonInterface.Enquiry enq2 = new CommonInterface.Enquiry();
                enq2.SetTestValues();
                string json = JsonConvert.SerializeObject(enq2, Formatting.Indented);
                using (System.IO.StreamWriter sw = new System.IO.StreamWriter(@"c:\\temp\enq.json"))
                {
                    sw.Write(json);
                    sw.Flush();
                    sw.Close();
                }
                enq2.EnquirerLink.Surname = "Wally";
                enq2.ConsentComments = "No Idea What to say...";
                using (System.IO.StreamWriter sw = new System.IO.StreamWriter(@"c:\\temp\enq2.json"))
                {
                    sw.Write(json);
                    sw.Flush();
                    sw.Close();
                }
                CommonInterface.Enquiry en3 = new CommonInterface.Enquiry();
                json = "";
                using (System.IO.StreamReader sr = new System.IO.StreamReader(@"c:\\temp\enq2.json"))
                {
                    json = sr.ReadToEnd();
                }
                en3 = Newtonsoft.Json.JsonConvert.DeserializeObject<CommonInterface.Enquiry>(json);
                rc = true;
            }
            catch (System.Exception ex)
            {
                Error = ex.ToString();
            }
            return rc;
        }
    }
}
