﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class Schools
    {
        public System.Xml.XmlDocument GetSchools()
        {
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            SIMS.Processes.TPSchool tps = new SIMS.Processes.TPSchool();
            d.InnerXml = tps.GetXmlChangedSchool(DateTime.Parse("1950-01-01"));
            return d;
        }
        public void UpdateSchool()
        {
            SIMS.Processes.MaintainHomeSchool maintainHomeSchool = new SIMS.Processes.MaintainHomeSchool();
            SIMS.Entities.Address address = new SIMS.Entities.Address();
            SIMS.Entities.SchoolSite schoolSite = new SIMS.Entities.SchoolSite();
            SIMS.Entities.Country country = new SIMS.Entities.Country();

            //schoolSite.AddressIDAttribute.Value = 99;
            schoolSite.SiteAddress = address;
            //schoolSite.ID = 0;
            schoolSite.Rank = 1;

            address.HouseNumber = "989";
            address.Street = "TestS";
            address.Town = "TestT";
            schoolSite.SiteName = "Test Site";

            maintainHomeSchool.CreateNew("SCH:OTHR");
            maintainHomeSchool.HomeSchool.Name = "SchoolTest";

            maintainHomeSchool.HomeSchool.ID = 0;
            maintainHomeSchool.IsPartnershipMemberSite(0);

            maintainHomeSchool.HomeSchool.SchoolSites.Add(schoolSite);

            maintainHomeSchool.SaveExternal(false);



        }
    }
}
