﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------


using System.Collections.Generic;


namespace CommonValues
{
    public class Roles
    {
        private Dictionary<string, CommonInterface.Role> _Values = new Dictionary<string, CommonInterface.Role>();
        public Roles()
        {
            AddRoll(0, "0", "No Role");
            AddRoll(1, "1", "Student");
            AddRoll(2, "2", "Contact");
            AddRoll(8, "8", "Employee");
            AddRoll(16, "16", "User");
            AddRoll(32, "32", "Candidate");
            AddRoll(64, "64", "Governor");
            AddRoll(128, "128", "Applicant");
            AddRoll(256, "256", "Enquirer");
            AddRoll(65536, "65536", "Teacher");
            AddRoll(131072, "131072", "Parent");
            AddRoll(262144, "262144", "Ex - Student");
            AddRoll(524288, "524288", "Ex - Contact");
            AddRoll(1048576, "1048576", "Ex - Employee");
            AddRoll(2097152, "2097152", "Ex - User");
            AddRoll(8388608, "8388608", "New Parent");
            AddRoll(16777216, "16777216", "Agent");
            AddRoll(33554432, "33554432", "BillPayer");
        }
        public void AddRoll(long rolebit, string code, string description)
        {
            CommonInterface.Role r = new CommonInterface.Role();
            r.RoleBit = rolebit;
            r.Description = description;
            r.Code = description;
            _Values.Add(r.Code, r);
        }
        public Dictionary<string, CommonInterface.Role> RoleValues
        {
            get
            {
                return _Values;
            }
        }
    }
}
/*
 0           No Role
1           Student
2           Contact
3           Student, Contact
8           Employee
16          User
24          Employee, User
32          Candidate
33          Student, Candidate
35          Student, Contact, Candidate
40          Employee, Candidate
64          Governor
128         Applicant
129         Student, Applicant
130         Contact, Applicant
131         Student, Contact, Applicant
160         Candidate, Applicant
161         Student, Candidate, Applicant
162         Contact, Candidate, Applicant
163         Student, Contact, Candidate, Applicant
256         Enquirer
258         Contact, Enquirer
65536       Teacher
65544       Employee, Teacher
65560       Employee, User, Teacher
131072      Parent
131074      Contact, Parent
262144      Ex-Student
524288      Ex-Contact
524290      Contact, Ex-Contact
655360      Parent, Ex-Contact
655362      Contact, Parent, Ex-Contact
1048576     Ex-Employee
2097152     Ex-User
2097160     Employee, Ex-User
2162696     Employee, Teacher, Ex-User
4194304     Ex-Candidate
8388608     New Parent
8388610     Contact, New Parent
8519682     Contact, Parent, New Parent
8912896     Ex-Contact, New Parent
16777216    Agent
16777218    Contact, Agent
33554432    BillPayer
33554434    Contact, BillPayer
33554690    Contact, Enquirer, BillPayer
33685506    Contact, Parent, BillPayer
33685635    Student, Contact, Applicant, Parent, BillPayer
33685667    Student, Contact, Candidate, Applicant, Parent, BillPayer
67108866    Contact, Prospective Pupil
67108992    Applicant, Prospective Pupil
67108993    Student, Applicant, Prospective Pupil
67109024    Candidate, Applicant, Prospective Pupil
67109025    Student, Candidate, Applicant, Prospective Pupil
 */
