﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using Newtonsoft.Json;
using System.Collections.Generic;

namespace CommonInterface
{
    [JsonObject(MemberSerialization.OptIn)]
    public class People
    {
        #region Serialize
        [JsonProperty]
        public int ID { get; set; }
        [JsonProperty]
        public Guid ExternalID { get; set; }
        [JsonProperty]
        public string Surname { get; set; }
        [JsonProperty]
        public string Title { get; set; }
        [JsonProperty]
        public string Forename { get; set; }
        [JsonProperty]
        public string Gender { get; set; }
        [JsonProperty]  
        public Dictionary<string, Role> Roles = new Dictionary<string, Role>();
        [JsonProperty]
        public Address AddressLink { get; set; }
        #endregion
        # region Non Seriazable 
        public string FullName { get { return Title + " " + Forename + " " + Surname; } }
        public virtual void SetTestValues()
        { 
            ID = 9999;
            ExternalID = Guid.NewGuid();
            Surname = "Surname";
            Forename = "Forename";
            Title = "Mr";
            Role r = new Role();
            r.SetTestValues();
            Roles.Add(r.Code,r);
            Gender = "Male";
            Address a = new Address();
            a.SetTestValues();
            AddressLink = a;
        }
    
        #endregion
        
    }
}
