﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Newtonsoft.Json;

namespace SIMSInterface
{
    public class SIMSEnquiry : CommonInterface.Enquiry
    {
        
        public void Process(Dictionary<int, CommonInterface.Enquiry> enq)
        {
            foreach(CommonInterface.Enquiry en in enq.Values)
            {
                // Does this enquiry exist already
                SIMS.Processes.Admissions.EnquiryBrowser enqb = new SIMS.Processes.Admissions.EnquiryBrowser();
                enqb.Search(en.ReferenceNumber, "", "", "", "", "", "", "", -1, "");
                int enq_id = -1;

                // AD+ is the source of truth
                foreach(SIMS.Entities.Admissions.Enquirer e in enqb.Enquiries)
                {
                    enqb.DeleteEnquiry(e.ID);
                }
                // Create a new one.
                Load(en);
                Save();
                // Add Error handling

                
            }

        }
        public void Load(CommonInterface.Enquiry enq)
        {

            SIMS.Processes.Admissions.EnquiryDetail ed = new SIMS.Processes.Admissions.EnquiryDetail();
            // First find the enquirer
            // If we know the enquirer then happy days...
            // if not we need to create the enquirer first.
            // we can load the enquiry
            if (enq.EnquiryID == -1)
            {
                // Create the person
                // assign enq.ID to the new value from the new person
            }
            SIMS.Entities.Person p = new SIMS.Entities.Person(enq.EnquirerLink.ID);
            ed.CreateNewEntity(p);


            ed.Enquiry.Reference = ReferenceNumber;
            ed.Enquiry.EnquiryDate = EnquiryDate;
            ed.Enquiry.Comments = Comments;
            ed.Enquiry.ActiveStateAttribute.Value = Active;

            //...
            // ParentChildGroup - Can't find it
            //EnquirerLink = new Enquirer(ed.Enquiry.Enquirer);

            foreach (SIMS.Entities.Admissions.ProspectivePupil pupil in ed.Enquiry.ProspectivePupils)
            {
                SIMSInterface.SIMSProspectivePupil spp = new SIMSProspectivePupil(pupil);
                ProspectivePupilLinks.Add(p.ID, spp);

            }
            
            //Swap these round..

            //EnquirerConsents.Clear();
            //foreach (SIMS.Entities.ParentalConsent pc in ed.Enquiry.ParentalConsents)
            //{
            //    CommonInterface.Consent c = new CommonInterface.Consent();
            //    c.Code = pc.Code;
            //    c.Description = pc.Description;
            //    c.Chosen = pc.Active;
            //    EnquirerConsents.Add(c.Code, c);
            //}
            //ConsentComments = ed.Enquiry.ParentalConsentComments;
            ////Struggling to find Marketing source
            ////ed.Enquiry.WhyThisSchoolAttribute
            //foreach (SIMS.Entities.Document d in ed.Enquiry.Documents)
            //{
            //    CommonInterface.DocumentLink doc = new CommonInterface.DocumentLink();
            //    doc.Type = d.DocumentType.Code;
            //    doc.Status = d.DocumentStatus.Code;
            //    doc.AttachmentFileName = "<Work to do> we would need to download and cache the local file name";
            //    doc.Note = d.Summary;
            //    // Needs some work.

            //}
        }
        public void Save()
        {
            // Save to SIMSs
        }
        public void Load(int enquiryID)
        {

            SIMS.Processes.Admissions.EnquiryDetail ed = new SIMS.Processes.Admissions.EnquiryDetail();
            ed.Populate(enquiryID);
            EnquiryID = enquiryID;
            ReferenceNumber = ed.Enquiry.Reference;
            EnquiryDate = ed.Enquiry.EnquiryDate;
            Comments = ed.Enquiry.Comments;
            Active = ed.Enquiry.ActiveStateAttribute.Value;
            // ParentChildGroup - Can't find it
            EnquirerLink = new Enquirer(ed.Enquiry.Enquirer);
            ProspectivePupilLinks.Clear();
            foreach (SIMS.Entities.Admissions.ProspectivePupil p in ed.Enquiry.ProspectivePupils)
            {
                SIMSInterface.SIMSProspectivePupil spp = new SIMSProspectivePupil(p);
                ProspectivePupilLinks.Add(p.ID, spp);

            }
            EnquirerConsents.Clear();
            foreach(SIMS.Entities.ParentalConsent pc in  ed.Enquiry.ParentalConsents)
            {
                CommonInterface.Consent c = new CommonInterface.Consent();
                c.Code = pc.Code;
                c.Description = pc.Description;
                c.Chosen = pc.Active;
                EnquirerConsents.Add(c.Code, c);
            }
            ConsentComments = ed.Enquiry.ParentalConsentComments;
            //Struggling to find Marketing source
            //ed.Enquiry.WhyThisSchoolAttribute
            foreach(SIMS.Entities.Document d in  ed.Enquiry.Documents)
            {
                CommonInterface.DocumentLink doc = new CommonInterface.DocumentLink();
                doc.Type = d.DocumentType.Code;
                doc.Status = d.DocumentStatus.Code;
                doc.AttachmentFileName = "<Work to do> we would need to download and cache the local file name";
                doc.Note = d.Summary;
                // Needs some work.

            }
        }
    }
}
