﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Newtonsoft.Json;

namespace CommonInterface
{
    [JsonObject(MemberSerialization.OptIn)]
    public class Visit
    {
        #region Serialize
        [JsonProperty]
        public int ID { get; set; }
        [JsonProperty]
        public string Type { get; set; }
        [JsonProperty]
        public DateTime VisitDate { get; set; }
        [JsonProperty]
        public string VisitTime { get; set; }
        [JsonProperty]
        public bool AllDay { get; set; }
        [JsonProperty]
        public string Location { get; set; }
        [JsonProperty]
        public Dictionary<int, Staff> VisitStaff = new Dictionary<int, Staff>();
        [JsonProperty]
        public Dictionary<int, Student> VisitStudents = new Dictionary<int, Student>();
        [JsonProperty]
        public Dictionary<int, OtherVisitors> VisitOtherVisitors = new Dictionary<int, OtherVisitors>();
        [JsonProperty]
        public Dictionary<int, ApplicantProspectivePupils> VisitApplicantsAndProspectivePupils = new Dictionary<int, ApplicantProspectivePupils>();
        [JsonProperty]
        public string Comments { get; set; }
        [JsonProperty]
        public Dictionary<int, DocumentLink> Documents = new Dictionary<int, DocumentLink>();
        #endregion
        #region Non Serialize
        public virtual void SetTestData()
        {
            ID = 112;
            Type = "Open Day";
            VisitDate = DateTime.Now.Date;
            VisitTime = DateTime.Now.ToShortTimeString();
            AllDay = false ;
            Location = "Great Hall";
            Staff s = new Staff();
            s.SetTestValues();
            VisitStaff.Add(s.ID, s);
            Student st = new Student();
            st.SetTestValues();
            VisitStudents.Add(st.ID, st);
            OtherVisitors ov = new OtherVisitors();
            ov.SetTestValues();
            VisitOtherVisitors.Add(ov.ID, ov);
            ApplicantProspectivePupils pp = new ApplicantProspectivePupils();
            pp.SetTestValues();
            VisitApplicantsAndProspectivePupils.Add(pp.ID, pp);
            Comments = "Comments..";
            DocumentLink d = new DocumentLink();
            d.SetTestValues();
            Documents.Add(d.ID, d);
        }
        #endregion

    }
}
