﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Newtonsoft.Json;

namespace CommonInterface
{
    [JsonObject(MemberSerialization.OptIn)]
    public class Enquiry
    {
        #region Serialize
        [JsonProperty]
        public string ReferenceNumber { get; set; }
        [JsonProperty]
        public DateTime EnquiryDate { get; set; }
        [JsonProperty]
        public string Comments { get; set; }
        [JsonProperty]
        public bool Active { get; set; }
        [JsonProperty]
        public bool ParentChildGroup { get; set; }
        [JsonProperty]
        public int EnquiryID { get; set; }
        [JsonProperty]
        public Enquirer EnquirerLink {get; set; }
        [JsonProperty]
        public Dictionary<int, ProspectivePupil> ProspectivePupilLinks = new Dictionary<int, ProspectivePupil>();
        [JsonProperty]
        public Dictionary<string, MarketingSource> MarketingSource = new Dictionary<string, MarketingSource>();
        [JsonProperty]
        public Dictionary<int, Communication> Communications = new Dictionary<int, Communication>();
        // Need to sort out which belongs to the equirer and the enquiry
        [JsonProperty]
        public Dictionary<string, Consent> EnquirerConsents = new Dictionary<string, Consent>();
        [JsonProperty]
        public string ConsentComments { get; set; }
        [JsonProperty]
        public Dictionary<int, DocumentLink> Documents = new Dictionary<int, DocumentLink>();
        #endregion
        #region non serialize
        public void SetTestValues()
        {   
            ReferenceNumber = "1234";
            EnquiryDate = DateTime.Now.Date;
            Comments = "Comments...";
            Active = true;
            ParentChildGroup = false;
            EnquiryID = 999;
            Enquirer en = new Enquirer();
            en.SetTestValues();
            EnquirerLink = en;
            ProspectivePupil pp = new ProspectivePupil();
            pp.SetTestValues();
            ProspectivePupilLinks.Add(pp.ID,pp);
            MarketingSource ms = new MarketingSource();
            ms.SetTestValues();
            MarketingSource.Add(ms.Code, ms);
            Communication comm = new Communication();
            comm.SetTestData();
            Communications.Add(comm.ID,comm);
            Consent c = new Consent();
            c.SetTestValues();
            EnquirerConsents.Add(c.Code,c); 
            ConsentComments = "Enquirer Consent Comments...";
            DocumentLink d = new DocumentLink();
            d.SetTestValues();
            Documents.Add(d.ID, d);


        }
        public void Load(string JSON)
        {
            // Deserialise the JSON and populate the object.
        }
        #endregion
    }

}
