﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class GetParents
    {
        public static System.Xml.XmlDocument GetChangedContacts(DateTime LastCallDateTime)
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContact tppc = new SIMS.Processes.TPPersonContact();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tppc.GetXmlChangedContacts(LastCallDateTime);
            return d;
        }
        public static System.Xml.XmlDocument GetContacts()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContact tppc = new SIMS.Processes.TPPersonContact();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tppc.GetXmlContacts();
            return d;
        }
        public static System.Xml.XmlDocument GetAddresses()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tppc = new SIMS.Processes.TPPersonContactInfo();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tppc.GetXmlAddresses();
            return d;
        }
        public static System.Xml.XmlDocument GetTelephones()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tppc = new SIMS.Processes.TPPersonContactInfo();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tppc.GetXmlTelephones();
            return d;
        }
        public static System.Xml.XmlDocument GetAEmails()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tppc = new SIMS.Processes.TPPersonContactInfo();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tppc.GetXmlEmails();
            return d;
        }
        public static System.Xml.XmlDocument GetContactsTelephones()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tpco = new SIMS.Processes.TPPersonContactInfo(); 
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tpco.GetXmlChangedPersonTelephones(DateTime.Now);
            return d;
        }
        public static System.Xml.XmlDocument GetContactsEmails()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tpco = new SIMS.Processes.TPPersonContactInfo();
            System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tpco.GetXmlChangedPersonEmails(DateTime.Now);      
            return d;
        }
        public static System.Xml.XmlDocument GetContactsAddresses()
        {
            // NB Must be logged in to SIMS
            SIMS.Processes.TPPersonContactInfo tpco = new SIMS.Processes.TPPersonContactInfo(); System.Xml.XmlDocument d = new System.Xml.XmlDocument();
            d.InnerXml = tpco.GetXmlChangedPersonAddresses(DateTime.Now);
            return d;
        }
    }
}
