﻿//Copyright: (c)Education Software Solutions Limited (ESS). 1984 - 2022
//          : This code has been written by ESS for use within its own systems.
//          : It is an unpublished proprietary work and as such it is illegal
//          : for it to be reproduced by any means or used without the express
//          : written permission of ESS.
//
//Grant for technical integrators
//
//Without prejudice to the copyright, ESS grants those persons or organisations
//who hold a current technical integrator agreement to use parts of the code
//with or without modification in order to provide a solution or service to
//mutual customers within the terms of their contract with ESS for commercial purposes.
//
//Those without a current technical agreement may use the code for a proof of concept
//but are strictly denied any rights to use the code for commercial gain or other
//purpose beyond a proof of concept.
//
//The code is provided as is and without warranty.
//The code is provide to demonstrate how solutions might be created and
//is not intended to meet any specific need without modification
//
//The use of the code is subject to our fair usage policy and must not be
//used to damage or attempt to damage ESS systems or services.
//
//All keys and secrets within the code are restricted to a demonstration sandbox
//and cannot access real data.  Data supplied is as is
//
//Contact partner.management@educationsoftwaresolutions.co.uk to engage with us.

using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;

namespace OneRosterExamples
{
    public class orEnrollments
    {
        protected static string GetType = "enrollments";
        public string ErrorMessage = "";
        public Dictionary<string, BaseClass.Enrollment> GetValues(string token, string key, HttpClient httpClient)
        {
            // GET /ims/oneroster/v1p1/enrollments
            int PageSize = 1000;
            int OffSet = 0;
            Dictionary<string, BaseClass.Enrollment> values = new Dictionary<string, BaseClass.Enrollment>();
            BaseClass.RootEnrollment enrolments = new BaseClass.RootEnrollment();
            string URL_ContactDetails = Helper.SetURL(GetType, OffSet, PageSize);
            string resp = BaseClass.DoCall(URL_ContactDetails, token, httpClient, key);
            try
            {
                enrolments = Newtonsoft.Json.JsonConvert.DeserializeObject<BaseClass.RootEnrollment>(resp);
                foreach (BaseClass.Enrollment u in enrolments.enrollments)
                {
                    values.Add(u.sourcedId, u);
                }
                // Very likely > PageSize

                while (true)
                {
                    if (enrolments.enrollments.Count != PageSize)
                    {
                        break; // all done
                    }
                    OffSet += PageSize;
                    URL_ContactDetails = Helper.SetURL(GetType, OffSet, PageSize);
                    resp = BaseClass.DoCall(URL_ContactDetails, token, httpClient, key);
                    enrolments = Newtonsoft.Json.JsonConvert.DeserializeObject<BaseClass.RootEnrollment>(resp);
                    foreach (BaseClass.Enrollment u in enrolments.enrollments)
                    {
                        values.Add(u.sourcedId, u);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}

