﻿/// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Net.Http;



namespace PostitCommon
{
    public class BearerToken
    {
        public string Token = "";
        //int HttpCode = 500;
        public BearerToken(AuthRequest arq, HttpClient httpClient)
        {

            string grant_type = "client_credentials";
            string client_id = arq.Client_ID; 
            string client_secret = arq.Secret;

            var form = new Dictionary<string, string>
                {
                    {"grant_type", grant_type},
                    {"client_id", client_id},
                    {"client_secret", client_secret},
                    { "scope", arq.Scopes },
                    { "acr_values","orgselected:"+arq.Organisation_ID }
                };

            var httpClientResponseTask = httpClient.PostAsync(arq.STS, new FormUrlEncodedContent(form));
            httpClientResponseTask.Wait();
            var result = httpClientResponseTask.Result;
            var responseStringTask = result.Content.ReadAsStringAsync();
            responseStringTask.Wait();
            //HttpCode = responseStringTask.Result.;
            string responseString = responseStringTask.Result;
            var jo2 = Newtonsoft.Json.JsonConvert.DeserializeObject(responseString);
            Newtonsoft.Json.Linq.JObject jo = Newtonsoft.Json.Linq.JObject.Parse(jo2.ToString());
            Token = (string)jo.SelectToken("access_token");
        }
    }

}
