﻿//Copyright: (c)Education Software Solutions Limited (ESS). 1984 - 2022
//          : This code has been written by ESS for use within its own systems.
//          : It is an unpublished proprietary work and as such it is illegal
//          : for it to be reproduced by any means or used without the express
//          : written permission of ESS.
//
//Grant for technical integrators
//
//Without prejudice to the copyright, ESS grants those persons or organisations
//who hold a current technical integrator agreement to use parts of the code
//with or without modification in order to provide a solution or service to
//mutual customers within the terms of their contract with ESS for commercial purposes.
//
//Those without a current technical agreement may use the code for a proof of concept
//but are strictly denied any rights to use the code for commercial gain or other
//purpose beyond a proof of concept.
//
//The code is provided as is and without warranty.
//The code is provide to demonstrate how solutions might be created and
//is not intended to meet any specific need without modification
//
//The use of the code is subject to our fair usage policy and must not be
//used to damage or attempt to damage ESS systems or services.
//
//All keys and secrets within the code are restricted to a demonstration sandbox
//and cannot access real data.  Data supplied is as is
//
//Contact partner.management@educationsoftwaresolutions.co.uk to engage with us.

using System;
using System.Collections.Generic;
using System.Net.Http;

namespace OneRosterExamples
{

    public class Classes
    {
        public string ErrorMessage = "";
        private string GetType = "classes";
        public class ClassRoot
        {
            public List<Classes_Response> classes { get; set; }
        }
        public class Classes_Response
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public string title { get; set; }
            public string classCode { get; set; }
            public string classType { get; set; }
            public string location { get; set; }
            public string course { get; set; }
            public List<BaseClass.Org> orgs { get; set; }
            public List<object> grades { get; set; }
            public List<object> subjects { get; set; }
            public BaseClass.School school { get; set; }
            public List<BaseClass.AcademicSession> terms { get; set; }
            public List<object> subjectCodes { get; set; }
            public List<object> resources { get; set; }
        }
        public Dictionary<string, Classes_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            int PageSize = 1000;
            int OffSet = 0;
            Dictionary<string, Classes_Response> values = new Dictionary<string, Classes_Response>();
            //BaseClass.RootUser users = new BaseClass.RootUser();
            string URL_ContactDetails = Helper.SetURL(GetType, OffSet, PageSize);
            string resp = BaseClass.DoCall(URL_ContactDetails, token, httpClient, key);
            try
            {
                ClassRoot _classes = Newtonsoft.Json.JsonConvert.DeserializeObject<ClassRoot>(resp);
                foreach (Classes_Response u in _classes.classes)
                {
                    values.Add(u.sourcedId, u);
                }
                // Very likely > PageSize

                while (true)
                {
                    if (_classes.classes.Count != PageSize)
                    {
                        break; // all done
                    }
                    OffSet += PageSize;
                    URL_ContactDetails = Helper.SetURL(GetType, OffSet, PageSize);
                    resp = BaseClass.DoCall(URL_ContactDetails, token, httpClient, key);
                    _classes = Newtonsoft.Json.JsonConvert.DeserializeObject<ClassRoot>(resp);
                    foreach (Classes_Response u in _classes.classes)
                    {
                        values.Add(u.sourcedId, u);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }

    }

}
