﻿//Copyright: (c)Education Software Solutions Limited (ESS). 1984 - 2022
//          : This code has been written by ESS for use within its own systems.
//          : It is an unpublished proprietary work and as such it is illegal
//          : for it to be reproduced by any means or used without the express
//          : written permission of ESS.
//
//Grant for technical integrators
//
//Without prejudice to the copyright, ESS grants those persons or organisations
//who hold a current technical integrator agreement to use parts of the code
//with or without modification in order to provide a solution or service to
//mutual customers within the terms of their contract with ESS for commercial purposes.
//
//Those without a current technical agreement may use the code for a proof of concept
//but are strictly denied any rights to use the code for commercial gain or other
//purpose beyond a proof of concept.
//
//The code is provided as is and without warranty.
//The code is provide to demonstrate how solutions might be created and
//is not intended to meet any specific need without modification
//
//The use of the code is subject to our fair usage policy and must not be
//used to damage or attempt to damage ESS systems or services.
//
//All keys and secrets within the code are restricted to a demonstration sandbox
//and cannot access real data.  Data supplied is as is
//
//Contact partner.management@educationsoftwaresolutions.co.uk to engage with us.

using System;
using System.Collections.Generic;
using System.Text;
using Newtonsoft.Json;
using System.Net.Http;

namespace OneRosterExamples
{
    public class BaseClass
    {
        public class Response<T>
        {
            public List<T> Value { get; set; }
        }
        // Root myDeserializedClass = JsonConvert.DeserializeObject<Root>(myJsonResponse);
        public class Org
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public string name { get; set; }
            public string type { get; set; }
            public string identifier { get; set; }
            public object parent { get; set; }
            public List<object> children { get; set; }
        }
        public class AcademicSession
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public string title { get; set; }
            public string startDate { get; set; }
            public string endDate { get; set; }
            public string type { get; set; }
            public AcademicSession parent { get; set; }
            public List<AcademicSession> children { get; set; }
        }
        // Root myDeserializedClass = JsonConvert.DeserializeObject<Root>(myJsonResponse);
        public class Enrollment
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public User user { get; set; }
            public Class _class { get; set; }
            public School school { get; set; }
            public string role { get; set; }
            public string primary { get; set; }
            public object startDate { get; set; }
            public object endDate { get; set; }
        }
        public class Agent
        {
            public string href { get; set; }
            public string sourcedId { get; set; }
            public string type { get; set; }
        }
        public class RootUser
        {
            public List<User> users { get; set; }
        }
        public class RootEnrollment
        {
            public List<Enrollment> enrollments { get; set; } 
        }    
        public class User
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public string username { get; set; }
            public List<object> userIds { get; set; }
            public string enabledUser { get; set; }
            public string givenName { get; set; }
            public string familyName { get; set; }
            public object middleName { get; set; }
            public string role { get; set; }
            public string identifier { get; set; }
            public string email { get; set; }
            public object sms { get; set; }
            public object phone { get; set; }
            public List<Agent> agents { get; set; }
            public List<Org> orgs { get; set; }
            public List<object> grades { get; set; }
            public string password { get; set; }
        }

        // Root myDeserializedClass = JsonConvert.DeserializeObject<Root>(myJsonResponse);

        public class School
        {
            public string href { get; set; }
            public string sourcedId { get; set; }
            public string type { get; set; }
        }

        public class Class
        {
            public string sourcedId { get; set; }
            public string status { get; set; }
            public DateTime dateLastModified { get; set; }
            public string title { get; set; }
            public string classCode { get; set; }
            public string classType { get; set; }
            public string location { get; set; }
            public List<object> grades { get; set; }
            public List<object> subjects { get; set; }
            public object course { get; set; }
            public School school { get; set; }
            public List<object> terms { get; set; }
            public List<object> subjectCodes { get; set; }
            public List<object> resources { get; set; }
        }


        public string ErrorMessage = "";
        public static string DoCall(string URL, string BearerToken, HttpClient _httpClient, string SubscriptionKey)
        {
            string resp = "";
            try
            {
                PostitCommon.Call c = new PostitCommon.Call(URL);
                // Execute the call
                // Passes in the bearer token and the subscription key
                resp = c.Execute(BearerToken, _httpClient, SubscriptionKey);
            }
            catch
            {

            }
            return resp;
        }    

    }
}
