﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SIMSInterface
{
    public class UPFSM
    {
        /// <summary>
        /// Gets the lookups for UPFSM
        /// </summary>
        /// <param name="server"></param>
        /// <param name="database"></param>
        /// <param name="user"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        public static System.Xml.XmlDocument GetXmlUPFSM_LookupsCommand(string server, string database, string user, string password)
        {
            ThirdPartyCommands.GetXmlUPFSM_LookupsCommand con = new ThirdPartyCommands.GetXmlUPFSM_LookupsCommand(server, database, false, user, password);
            System.Xml.XmlDocument d = con.ExecuteCommand();

            return d;
        }
        /// <summary>
        /// Gets the configuration for UPFSM - I.e. the status of each NC year group with regard to UPFSM entitlement
        /// </summary>
        /// <param name="server"></param>
        /// <param name="database"></param>
        /// <param name="user"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        public static System.Xml.XmlDocument GetXmlUPFSM_ConfigCommand(string server, string database, string user, string password)
        {
            ThirdPartyCommands.GetXmlUPFSM_ConfigCommand con = new ThirdPartyCommands.GetXmlUPFSM_ConfigCommand(server, database, false, user, password);
            System.Xml.XmlDocument d = con.ExecuteCommand();

            return d;
        }

        /// <summary>
        /// Gets the exceptions for UPFSM for a date range.
        /// </summary>
        /// <param name="server"></param>
        /// <param name="database"></param>
        /// <param name="user"></param>
        /// <param name="password"></param>
        /// <param name="startDate">nullable = start of time - start date</param>
        /// <param name="endDate">nullable = end of relative time - end date</param>
        /// <returns></returns>
        public static System.Xml.XmlDocument GetXmlUPFSM_ExceptionsCommand(string server, string database, string user, string password, DateTime? startDate, DateTime? endDate)
        {

            ThirdPartyCommands.GetXmlUPFSM_ExceptionsCommand con = new ThirdPartyCommands.GetXmlUPFSM_ExceptionsCommand(server, database, false, user, password);
            System.Xml.XmlDocument d = con.ExecuteCommand(startDate, endDate);

            return d;
        }
    }
}
