﻿using System;
using System.Collections.Generic;
using System.Net.Http;

namespace RAPAPIExamples
{
    public class RAPLearnerParents : RAPAPIExamples.BaseClass
    {
            public class RAPLearnerParent
        {
            public string Id { get; set; }
            public string Title { get; set; }
            public string FirstName { get; set; }
            public string LastName { get; set; }
            public string EmailAddress { get; set; }
            public DateTime LastUpdated { get; set; }
            public List<string> StudentMembers { get; set; }
            public string MainPhoneNumber { get; set; }
        }
        protected static string GetType = "learnerparent";
        public string ErrorMessage = "";
        public Dictionary<string, RAPLearnerParent> GetValues(string token, string organisationID,  HttpClient httpClient)
        {
            // GET /ims/oneroster/v1p1/enrollments
            int OffSet = 0;
            Dictionary<string, RAPLearnerParent> values = new Dictionary<string, RAPLearnerParent>();
            string URL_Parents = null;
            if (PageSize != -1)
            {
                URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
            }
            else
            {
                URL_Parents = SetURL(GetType, organisationID);
            }
            string resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
            try
            {
                List<RAPLearnerParent> responses = new List<RAPLearnerParent>();
                responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPLearnerParent>>(resp);
                foreach (RAPLearnerParent u in responses)
                {
                    values.Add(u.Id, u);
                }
                // Very likely > PageSize

                while (true && PageSize != -1)
                {
                    if (responses.Count != PageSize)
                    {
                        break; // all done
                    }
                    OffSet += PageSize;
                    URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
                    resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
                    responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPLearnerParent>>(resp);
                    foreach (RAPLearnerParent u in responses)
                    {
                        values.Add(u.Id, u);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}

