﻿using System;
using System.Collections.Generic;
using System.Net.Http;

namespace RAPAPIExamples
{
    public class RAPStaffs : RAPAPIExamples.BaseClass
    {
        // Root myDeserializedClass = JsonConvert.DeserializeObject<List<Root>>(myJsonResponse);
        public class RAPStaff
        {
            public string Id { get; set; }
            public string Title { get; set; }
            public string FirstName { get; set; }
            public string LastName { get; set; }
            public string EmailAddress { get; set; }
            public DateTime LastUpdated { get; set; }
            public string MainPhoneNumber { get; set; }
            public string Role { get; set; }
            public string OrganisationType { get; set; }
            public string ExternalId { get; set; }
        }
        protected static string GetType = "staff";
        public string ErrorMessage = "";
        public Dictionary<string, RAPStaff> GetValues(string token, string organisationID, HttpClient httpClient)
        {
            // GET /ims/oneroster/v1p1/enrollments
            int OffSet = 0;
            Dictionary<string, RAPStaff> values = new Dictionary<string, RAPStaff>();
            string URL_Parents = null;
            if (PageSize != -1)
            {
                URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
            }
            else
            {
                URL_Parents = SetURL(GetType, organisationID);
            }
            string resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
            try
            {
                List<RAPStaff> responses = new List<RAPStaff>();
                responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPStaff>>(resp);
                foreach (RAPStaff u in responses)
                {
                    values.Add(u.Id, u);
                }
                // Very likely > PageSize

                while (true && PageSize != -1)
                {
                    if (responses.Count != PageSize)
                    {  
                        break; // all done
                    }
                    OffSet += PageSize;
                    URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
                    resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
                    responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPStaff>>(resp); 
                    foreach (RAPStaff u in responses)
                    {
                        values.Add(u.Id, u);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}

