﻿using System;
using System.Collections.Generic;
using System.Net.Http;

namespace RAPAPIExamples
{
    public class RAPStudents : RAPAPIExamples.BaseClass
    {

        public class RegistrationGroup : Group
        {
        }
        public class YearGroup : Group
        {
        }
        public class RAPStudent
        {
            public string Id { get; set; }
            public string Title { get; set; }
            public string FirstName { get; set; }
            public string MiddleName { get; set; }
            public string LastName { get; set; }
            public string EmailAddress { get; set; }
            public string DateOfBirth { get; set; }
            public string Gender { get; set; }
            public bool PupilPremiumStatus { get; set; }
            public YearGroup YearGroup { get; set; }
            public RegistrationGroup RegistrationGroup { get; set; }
            public DateTime LastUpdated { get; set; }
            public string StudentExtId { get; set; }
            public string UniquePupilNumber { get; set; }
            public string AdmissionNumber { get; set; }
            public string ParentEmailAddress { get; set; }
            public string MainPhoneNumber { get; set; }
        }

      
        protected static string GetType = "students";
        public string ErrorMessage = "";
        public Dictionary<string, RAPStudent> GetValues(string token, string organisationID,  HttpClient httpClient)
        {
            // GET /ims/oneroster/v1p1/enrollments
            int OffSet = 0;
            Dictionary<string, RAPStudent> values = new Dictionary<string, RAPStudent>();
            string URL_Parents = null;
            if (PageSize != -1)
            {
                URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
            }
            else
            {
                URL_Parents = SetURL(GetType, organisationID);
            }
            string resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
            try
            {
                List<RAPStudent> responses = new List<RAPStudent>();
                responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPStudent>>(resp);
                foreach (RAPStudent u in responses)
                {
                    values.Add(u.Id, u);
                }
                // Very likely > PageSize

                while (true && PageSize != -1)
                {
                    if (responses.Count != PageSize)
                    {
                        break; // all done
                    }
                    OffSet += PageSize;
                    URL_Parents = SetURL(GetType, organisationID, OffSet, PageSize);
                    resp = BaseClass.DoCall(URL_Parents, token, httpClient, "");
                    responses = Newtonsoft.Json.JsonConvert.DeserializeObject<List<RAPStudent>>(resp);
                    foreach (RAPStudent u in responses)
                    {
                        values.Add(u.Id, u);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}

