﻿//Copyright: (c)Education Software Solutions Limited (ESS). 1984 - 2022
//          : This code has been written by ESS for use within its own systems.
//          : It is an unpublished proprietary work and as such it is illegal
//          : for it to be reproduced by any means or used without the express
//          : written permission of ESS.
//
//Grant for technical integrators
//
//Without prejudice to the copyright, ESS grants those persons or organisations
//who hold a current technical integrator agreement to use parts of the code
//with or without modification in order to provide a solution or service to
//mutual customers within the terms of their contract with ESS for commercial purposes.
//
//Those without a current technical agreement may use the code for a proof of concept
//but are strictly denied any rights to use the code for commercial gain or other
//purpose beyond a proof of concept.
//
//The code is provided as is and without warranty.
//The code is provide to demonstrate how solutions might be created and
//is not intended to meet any specific need without modification
//
//The use of the code is subject to our fair usage policy and must not be
//used to damage or attempt to damage ESS systems or services.
//
//All keys and secrets within the code are restricted to a demonstration sandbox
//and cannot access real data.  Data supplied is as is
//
//Contact partner.management@educationsoftwaresolutions.co.uk to engage with us.

using System;
using System.Collections.Generic;
using VMC;
using System.Net.Http;
using PostitCommon;
using PostitCore;

namespace FullDemo
{
    public class Program
    {


        /// <summary>
        /// The aim of this demo is to 
        /// 1. Use vendor management to get a list of schools and their credentials
        ///    a. Get a VMC access token
        ///    b. Make a VMC call to get a list of schools subscribing to the app
        ///    c. Make a VMC call to get credentials for the app.
        /// 2. To make a OneRoster call
        ///    a. Get a OneRoster access token
        ///    b. Make a OneRoster call
        /// 
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {
            PostitCommon.Log.LogFile = @"c:\temp\demo.log";
            // Get the vendo management token
            string VMCtoken = VMCToken.VendorManagementToken(httpClient);
            // Place holder for Dex token
            string DeXToken = "";
            // Placeholder for OneRoster token
            string OneRosterToken = "";  
            // Use it to get a list of schools using the requested app.
            Call c = new Call(string.Format("https://rap.sims.co.uk/api/v1/partner/{0}/GetSiteByApplication", ApplicationID));
            string resp = c.Execute(VMCtoken, httpClient, "");
            // Create a list of customers (schools)
            var _Customers = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Customer>>(resp);
            // for each school - see what credentials are available.
            foreach (Customer cus in _Customers)
            {
                // Request for all of the available credentials for the app for the designated school
                Call c2 = new Call(string.Format("https://rap.sims.co.uk/api/v1/partner/{0}/{1}/Clients",
                                            ApplicationID, cus.OrganisationId));
                string resp2 = c2.Execute(VMCtoken, httpClient, "");
                // Get a list of the credentials
                var _Credential = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Credential>>(resp2);
                // For each of these get some data
                foreach (Credential cred in _Credential)
                {
                    // Whilst this is not foolproof, it will probably work but at test time, the client id for
                    // the TI apps need to be extracted and an exact match should replace the general
                    // idea below.
                    if (cred.ClientId.Contains("oneroster"))
                    {
                        // One roster scopes are different to OData DeX!
                         OneRosterToken = SchoolTokens.SchoolOneRosterDataAccessToken(httpClient, cred.ClientId, cred.Secret, cus.OrganisationId.ToString());
                        // Get some data from one roster - even an empty set is success
                    }
                }
                // One Roster and RAP (For organisations) use the same bearer tokens.

                // Have a look at this to see how data can be extracted from RAP.
                // Warning - if you ask for non-existent data you will get an invalid end point error rather than an empty collection.
                GetMyRAPData getMyRAPData = new GetMyRAPData();
                getMyRAPData.Load(httpClient, cus.OrganisationId.ToString(), OneRosterToken);

                // Basic one Roster Example
                OneRosterExamples.orStudents ors = new OneRosterExamples.orStudents();
                Dictionary<string, OneRosterExamples.BaseClass.User> students = ors.GetValues(OneRosterToken, OCP_Key, httpClient);
             
                // For a wider set of One Roster examples - look at
                GetMyOneRosterData ord = new GetMyOneRosterData();
                ord.Load(httpClient,OneRosterToken,OCP_Key);
}
        }
        /// <summary>
        ///  API Manager key is needed to access DeX endpoints - a sample value is below which will be throttled.
        /// </summary>
        public static string OCP_Key = "03b99417959742feb7dd08f94495e738";
        /// <summary>
        /// 
        /// This can be accessed via the SIMS UI - Edit the application in SIMS ID
        /// Look at the URL 
        /// https://ti.sims.co.uk/Applications/ManageApplication?applicationId=2585d852-956b-457d-b510-03584a3f02bf&siteId=18996
        /// and extract the applicationId like in the example above.
        /// 
        /// </summary>
        public static string ApplicationID = "2585d852-956b-457d-b510-03584a3f02bf";
        public static CallInfo callInfo = new CallInfo();

        public static HttpClient httpClient = new HttpClient(); 
    }
}

        