﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;

using System.Net.Http;
using System.Net.Http.Headers;
using System.Xml;
using System.IO;
//using System.Drawing.Common;

namespace PostitCommon
{
    public class Call
    {
        public string ErrorMessage = "";
        private string URL { get; set; }
        private string Name { get; set; }
        private string Content_type { get; set; }
        public Call(string Url)
        {
            URL = Url;
            Name = "Direct URL";
        }
        public string Post(string BearerToken, HttpClient httpClient, string OCP_APIM_Key, string Payload)
        {
            string rc = "";
            try
            {
                var request = new HttpRequestMessage()
                {
                    RequestUri = new Uri(URL),
                    Method = HttpMethod.Post,
                };
                request.Headers.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                request.Content = new StringContent(Payload, System.Text.Encoding.UTF8, "application/json");
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", BearerToken);
                request.Headers.Add("Ocp-Apim-Subscription-Key", OCP_APIM_Key);
                var httpClientResponseTask = httpClient.SendAsync(request);
                httpClientResponseTask.Wait();
                var result = httpClientResponseTask.Result;
                var responseStringTask = result.Content.ReadAsStringAsync();
                rc = responseStringTask.Result.ToString();

            }

            catch (Exception ex)
            {

                ErrorMessage = ">>>>+" + Name + ": " + ex.Message;
                PostitCommon.Log.Write(ErrorMessage);
            }
            return rc;
        }
        private MultipartContent MPContent = null;
        private string BatchNumber = "";
        public void SetMultiPart(Guid batchIdString)
        {
            BatchNumber = batchIdString.ToString();
            MPContent  = new MultipartContent("mixed", $"batch_{batchIdString}");
        }
        public void AddMP(HttpContent content)
        {
            MPContent.Add(content);
        }
        public string BatchPost(string BearerToken, HttpClient httpClient, string OCP_APIM_Key)
        {
            string rc = "";
            try
            {
                var request = new HttpRequestMessage()
                {
                    RequestUri = new Uri(URL),
                    Method = HttpMethod.Post,
                };
                //httpClient.Timeout = TimeSpan.FromSeconds(300);


                //MediaTypeWithQualityHeaderValue mt = new MediaTypeWithQualityHeaderValue("multipart/mixed; boundary=batch_" + BatchNumber);
                //request.Headers.Accept.Add(mt);
                request.Content = new StringContent(MPContent.ToString(), System.Text.Encoding.UTF8, "application/json");
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", BearerToken);
                request.Headers.Add("Ocp-Apim-Subscription-Key", OCP_APIM_Key);
                var httpClientResponseTask = httpClient.SendAsync(request);
                httpClientResponseTask.Wait();
                var result = httpClientResponseTask.Result;
                var responseStringTask = result.Content.ReadAsStringAsync();
                rc = responseStringTask.Result.ToString();

            }

            catch (Exception ex)
            {

                ErrorMessage = ">>>>+" + Name + ": " + ex.Message;
                PostitCommon.Log.Write(ErrorMessage);
            }
            return rc;
        }
        public string Execute(string BearerToken, HttpClient httpClient, string OCP_APIM_Key)
        {
            string rc = "";
            try
            {
                var request = new HttpRequestMessage()
                {
                    RequestUri = new Uri(URL),
                    Method = HttpMethod.Get,
                };
                if (Content_type != null && Content_type != "")
                {
                    request.Headers.Accept.Add(new MediaTypeWithQualityHeaderValue(Content_type));
                }
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", BearerToken);
                request.Headers.Add("Ocp-Apim-Subscription-Key", OCP_APIM_Key);
                var httpClientResponseTask = httpClient.SendAsync(request);
                httpClientResponseTask.Wait();
                var result = httpClientResponseTask.Result;
                var responseStringTask = result.Content.ReadAsStringAsync();
                rc = responseStringTask.Result.ToString();

            }

            catch (Exception ex)
            {

                ErrorMessage = ">>>>+" + Name + ": " + ex.Message;
                PostitCommon.Log.Write(ErrorMessage);
            }
            return rc;
        }

    }
}
