﻿// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
// ---------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
namespace PostitCommon
{
    /// <summary>
    /// V3 TEST V3 TEST V3 TEST V3 TEST V3 TEST V3 TEST V3 TEST V3 TEST V3 TEST 
    /// </summary>

    public class CallInfo
    {
        public PostitCommon.AuthRequest arq = new PostitCommon.AuthRequest();
        public PostitCommon.BearerToken bearerToken = null;
        public void SetCredentials(HttpClient httpClient,
                                            string clientID,
                                            string secret,
                                            string orgId)
        {
            SetCredentials(httpClient,
                                        clientID,
                                        secret,
                                        orgId,
                                        "https://sts.sims.co.uk/connect/token",
                                        "599238a4c8454a24af679bb5777209ca");
        }
        /// <summary>
        /// Set credentials and get a token
        /// </summary>
        public void SetCredentials(HttpClient httpClient,
                                    string clientID,
                                    string secret,
                                    string orgId,
                                    string sts,
                                    string subKey)
        {

            arq = new PostitCommon.AuthRequest();
            bearerToken = null;
            arq.Scopes = "partnerserverapplication partner";
            arq.STS = sts;

            arq.Client_ID = clientID;
            arq.Organisation_ID = orgId;
            arq.Secret = secret;
            // Subscription key should be changed this one is demo app only
            // it must be replaced with a vendor specific key and will
            // be withdrawn randomly...
            arq.OCP_APIM_Key = subKey;
            // COntact partner.support@capita.co.uk to get your own key.


            // Get a token

            bearerToken = new PostitCommon.BearerToken(arq, httpClient);
        }
    }
}