﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;


namespace RAPAPIExamples
{
    public class BaseClass
    {
        public class Group
        {
            public string Id { get; set; }
            public string Name { get; set; }
            public string GroupType { get; set; }
        }
        /// <summary>
        /// Paging is currently turned off until we establish whether the API supports it.
        /// </summary>
        protected int PageSize = -1;

        //https://rap.sims.co.uk/api/v1/Organisation/{{organisation_id}}/students
        //https://rap.sims.co.uk/api/v1/Organisation/{{organisation_id}}/staff
        //https://rap.sims.co.uk/api/v1/Organisation/{{organisation_id}}/learnerparent
        public static string BaseUrl = "https://rap.sims.co.uk/api/v1/Organisation/";
        public static string SetURL(string call,string organisationID)
        {

            string url = BaseUrl + organisationID + "/" + call;
            return url;
        }
        public static string SetURL(string call, string organisationID,int offset, int pageSize)
        {

            string url = BaseUrl + organisationID + "/" + call + String.Format("?limit={1}&offset={0}", offset, pageSize);
            return url;
        }
        public class Response<T>
        {
            public List<T> Value { get; set; }
        }
        public string ErrorMessage = "";
        public static string DoCall(string URL, string BearerToken, HttpClient _httpClient, string SubscriptionKey)
        {
            string resp = "";
            try
            {
                PostitCommon.Call c = new PostitCommon.Call(URL);
                // Execute the call
                // Passes in the bearer token and the subscription key
                resp = c.Execute(BearerToken, _httpClient, SubscriptionKey);
            }
            catch
            {

            }
            return resp;
        }
    }
}
