// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Net;
using SIMS.ComInterface;
using System.IO;

namespace SIMS.UserInterfaces.EProcurement
{
    /// <summary>
    /// Form to test all the web methods of a specified web service
    /// 
    /// All the web services are tested through the EProcComInterface assembly. 
    /// Unfortunatley we cannot create the COM objects themselves here, as .NET does not
    /// support instanciating a COM object that was created in .NET
    /// </summary>
    /// <author>Robert O'Reilly</author>
    /// <date>17 December 2007</date>
    /// <status>Does not require approval</status>
    public partial class WebServiceTest : Form
    {

        /// <summary>
        /// Standard constructor
        /// </summary>
        public WebServiceTest()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Fetch the index of documents
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butFetch_Click(object sender, EventArgs e)
        {
            FetchIndex(DateTime.MinValue);
        }

        /// <summary>
        /// Fetch the index of documents from the specified date
        /// </summary>
        /// <param name="fromDate"></param>
        private void FetchIndex(DateTime fromDate)
        {
            EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);
            
            try
            {
                Dictionary<string, int> docCount = new Dictionary<string, int>();
                string xml;
                if (fromDate == DateTime.MinValue)
                    xml = ws.FetchIndex();
                else
                    xml = ws.FetchIndexFromDate(fromDate);
                // now parse through this xml
                XmlDocument docList = new XmlDocument();
                docList.LoadXml(xml);
                lstDocuments.Items.Clear();
                lstDocuments.MultiColumn = false;
                lstDocuments.SelectionMode = SelectionMode.One;
                lstDocuments.BeginUpdate();
                int count = 0;
                foreach (XmlElement el in docList.GetElementsByTagName("document"))
                {
                    count++;
                    string docId = el.GetAttribute("uuid");
                    string type = el.GetAttribute("type");
                    lstDocuments.Items.Add(docId + " (" + type + ")");
                    if (docCount.ContainsKey(type))
                        docCount[type]++;
                    else
                        docCount[type] = 1;
                }
                lstDocuments.EndUpdate();
                // output the results
                if (fromDate == DateTime.MinValue)
                    txtOutput.Text = "FetchIndex output:";
                else
                    txtOutput.Text = "FetchIndexFromDate output:";
                if (count > 0)
                {
                    foreach (string key in docCount.Keys)
                    {
                        txtOutput.Text += "\r\n" + docCount[key] + " " + key;
                    }
                }
                else
                {
                    txtOutput.Text += "\r\nThere are no documents ready to be downloaded. Call ResetAll to reset all the documents status.";
                }
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }
        }

        /// <summary>
        /// Reset the document list
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butReset_Click(object sender, EventArgs e)
        {
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

                txtOutput.Text = "ResetAll output:" + ws.ResetAll();
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }
        }

        /// <summary>
        /// Fetch a document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butFetchDoc_Click(object sender, EventArgs e)
        {
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

                // get the selected item
                string docId = txtDocID.Text;
                XmlDocument docXml = new XmlDocument();
                docXml.LoadXml(ws.FetchDoc(docId));
                txtOutput.Text = docXml.OuterXml;
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }


        }

        /// <summary>
        /// Update a document status
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butStatus_Click(object sender, EventArgs e)
        {
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

                // get the selected item
                string docId = txtDocID.Text;
                txtOutput.Text = "UpdateDocumentStatus output:" + ws.UpdateDocumentStatus(docId, true).ToString();
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }

        }

        /// <summary>
        /// Update the docid textbox
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void lstDocuments_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (lstDocuments.SelectedItem != null)
            {
                txtDocID.Text = (string)lstDocuments.SelectedItem;
                txtDocID.Text = txtDocID.Text.Substring(0, txtDocID.Text.IndexOf(" "));
            }
            
        }

        /// <summary>
        /// Reset the password
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butChangePassword_Click(object sender, EventArgs e)
        {
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

                // change the password
                string newPass = ws.ChangePassword();
                txtPass.Text = newPass;
                txtOutput.Text = "ChangePassword output:" + newPass;
                MessageBox.Show("The new password for " + txtUser.Text + " is " + newPass + ".\r\nPlease make a note of this and tell the team.");
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }
        }

        /// <summary>
        /// Test the web service
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butTest_Click(object sender, EventArgs e)
        {
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);
                txtOutput.Text = "Test output:" + ws.Test();

            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }
        }


        /// <summary>
        /// FetchIndexFromDate event handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butFetchFromDate_Click(object sender, EventArgs e)
        {
            FetchIndex(dtIndex.Value);
        }

        private void butSendOrder_Click(object sender, EventArgs e)
        {
            // get the xml in the textbox and send it
            try
            {
                EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

                // send the order the password
                bool output = ws.SendOrder(txtPurchaseOrder.Text);
                txtOutput.Text = "SendOrder output:" + output;
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void butBrowse_Click(object sender, EventArgs e)
        {
            if (File.Exists(txtOrdersPath.Text))
                dirBrowse.SelectedPath = txtOrdersPath.Text;
            if (dirBrowse.ShowDialog() == DialogResult.OK)
            {
                txtOrdersPath.Text = dirBrowse.SelectedPath;
            }


        }

        private void dirBrowse_HelpRequest(object sender, EventArgs e)
        {

        }

        private void butUpload_Click(object sender, EventArgs e)
        {
            int errCount = 0;
            int fileCount = 0;
            int goodCount = 0;
            int skippedCount = 0;
            string orderFiles = "";
            string badFiles = "";
            string skippedFiles = "";
            if (!Directory.Exists(txtOrdersPath.Text))
            {
                MessageBox.Show("Please choose a valid path");
                return;
            }
            EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);
            // now loop through each xml file in the directory and send it
            foreach (string orderFileName in Directory.GetFiles(txtOrdersPath.Text))
            {
                string thisFileName = orderFileName.Substring(orderFileName.LastIndexOf("\\"));
                // check the filename
                if (orderFileName.ToLower().EndsWith(".xml"))
                {
                    try
                    {
                        string xml = "";
                        orderFiles += thisFileName + "\r\n";
                        fileCount++;
                        // read the string
                        using (StreamReader rdr = new StreamReader(orderFileName))
                        {
                            xml = rdr.ReadToEnd();
                        }
                        // now send it
                        ws.SendOrder(xml);
                        goodCount++;

                    }
                    catch (Exception ex)
                    {
                        errCount++;
                        badFiles += thisFileName + ":" + ex.Message + "\r\n";
                    }
                }
                else
                {
                    skippedFiles += thisFileName + "\r\n";
                    skippedCount++;
                }

            }
            // now show the output
            txtOutput.Text = String.Format("Sent {0} files of which {1} sent OK and {2} had errors. {3} files were skipped as they did not have a .xml extension\r\n", fileCount, goodCount, errCount, skippedCount);
            txtOutput.Text += "Sent Files\r\n" + orderFiles;
            txtOutput.Text += "Bad Files\r\n" + badFiles;
            txtOutput.Text += "Skipped Files\r\n" + skippedCount;

        }

        private void butShowFetchFromDateXML_Click(object sender, EventArgs e)
        {
            DateTime fromDate = dtIndex.Value;
            EProcService ws = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);
            try
            {
                Dictionary<string, int> docCount = new Dictionary<string, int>();
                string xml;
                if (fromDate == DateTime.MinValue)
                    xml = ws.FetchIndex();
                else
                    xml = ws.FetchIndexFromDate(fromDate);

                txtOutput.Text = xml;
            }
            catch (Exception ex)
            {
                txtOutput.Text = ex.Message;
            }
        }


        private void butDownload_Click(object sender, EventArgs e)
        {
            bool hasFailed = false;
            string failedServices = "";
            string xmlOutputDir = "XmlOutput\\";

            string serviceXmlOutputDir = xmlOutputDir + txtUser.Text + "\\";
            if (!Directory.Exists(serviceXmlOutputDir))
                Directory.CreateDirectory(serviceXmlOutputDir);

            EProcService service = Program.ServiceFactory.Add(txtUrl.Text, txtUser.Text, txtPass.Text);

            int docCount = 0;
            try 
            {
                foreach (string item in lstDocuments.Items)
                {
                    string docId = item.Substring(0, item.IndexOf(" "));
                    try
                    {
                        // download the XML
                        string docXml = service.FetchDoc(docId);
                        // write it out
                        string fileName = serviceXmlOutputDir + docId + ".xml";
                        // write the xml out
                        using (StreamWriter sw = new StreamWriter(fileName))
                        {
                            sw.Write(docXml);
                        }
                        docCount++;
                    }
                    catch (Exception iex)
                    {
                        hasFailed = true;
                        failedServices += iex.Message + "\r\n";
                    }
                }
            }
            catch (Exception ex)
            {
                hasFailed = true;
                failedServices += ex.Message + "\r\n";
            }
            // output the message
            if (hasFailed) 
                txtOutput.Text = failedServices;
            else 
                txtOutput.Text = "";
            //  now add the output
            txtOutput.Text = "Successfully downloaded " + docCount + " documents.\r\nSaved to directory:\r\n" +
                (Directory.GetCurrentDirectory() + "\\" + serviceXmlOutputDir).Replace("\\\\", "\\");
        }

        private void txtUser_TextChanged(object sender, EventArgs e)
        {

        }









    }
}