// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SIMS.UserInterfaces.EProcurement
{
    /// <summary>
    /// Form to launch the three other types of test forms in the application.
    /// 
    /// All the web services are tested through the EProcComInterface assembly. 
    /// Unfortunatley we cannot create the COM objects themselves here, as .NET does not
    /// support instanciating a COM object that was created in .NET
    /// </summary>
    /// <author>Robert O'Reilly</author>
    /// <date>17 December 2007</date>
    /// <status>Does not require approval</status>
    public partial class PortalServiceTestBed : Form
    {
        /// <summary>
        /// Standard constructor
        /// </summary>
        public PortalServiceTestBed()
        {
            InitializeComponent();
        }



        /// <summary>
        /// Launch the web service test form
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butTestServices_Click(object sender, EventArgs e)
        {
            WebServiceTest ws = new WebServiceTest();
            ws.Show();
        }

        /// <summary>
        /// Launch the update internet form
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butUpdateInternet_Click(object sender, EventArgs e)
        {
            UpdateInternetSettings internet = new UpdateInternetSettings();
            internet.Show();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            AboutBox b = new AboutBox();
            b.ShowDialog();
        }
    }
}