// ---------------------------------------------------------------------------------
// 
// Sample code is copyright (c) Education Software Solutions Ltd 2021
// 
// Education Software Solutions (Hereafter 'ESS') provide sample code to 
// ESS Technical Integrators (Hereafter 'TIs') under consultancy 
// or as part of our TI programme to assist in the production of applications and services
// to benefit mutual customers.
// 
// Sample code is supplied by the ESS TI Team and may be augmented / changed at any time.
//
// ESS grants non exclusive rights to use the code on an 'as is' basis to contracted TIs 
// for the purpose of interfacing with ESS Products.  Code may be used in whole or in part 
// for the TIs products. Rights are subject to the restrictions below.
//
// This code may not be used for commercial purposes without a current TI agreement   
// in place with ESS.  The use of any sample code may incur liabilities for TI contractual 
// fees.  
//
// If the code is provided to eductational establishments for their own use then further 
// consent from ESS must be obtained before the code can be re-used for commercial gain.
//
// No warranty is provided . This header must be retained within the code and Copyright acknowleged as
// Parts (c) Education Software Solutions Ltd 2021 in version info.
//
// Code samples may be used to support other partners and no exclusivity is implied herein
//
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIMS.ComInterface;
namespace SIMS.UserInterfaces.EProcurement
{
    /// <summary>
    /// Form used to update the internet settings for connecting to the web services
    /// 
    /// All the web services are tested through the EProcComInterface assembly. 
    /// Unfortunatley we cannot create the COM objects themselves here, as .NET does not
    /// support instanciating a COM object that was created in .NET
    /// </summary>
    /// <author>Robert O'Reilly</author>
    /// <date>17 December 2007</date>
    /// <status>Does not require approval</status>
    public partial class UpdateInternetSettings : Form
    {
        private InternetConnection inet;

        /// <summary>
        /// Standard forms constructor that also gets a reference to the internetconnection object
        /// </summary>
        public UpdateInternetSettings()
        {
            InitializeComponent();
            inet = Program.ServiceFactory.Connection;
        }

        /// <summary>
        /// Appends output to the textbox
        /// </summary>
        /// <param name="text"></param>
        private void AppendToOutput(string text)
        {
            txtOutput.Text = text + "\r\n" + txtOutput.Text;
            Application.DoEvents();
        }

        
        /// <summary>
        /// Do the internet connection test
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butTest_Click(object sender, EventArgs e)
        {
            try
            {
                AppendToOutput("Attempting connection to :" + txtTestUrl.Text + "\r\n");
                if (!inet.UseProxy)
                {
                    AppendToOutput("Not using proxy server");
                }
                else
                {

                    if (inet.UseDefaultProxy)
                    {
                        AppendToOutput("Using default IE proxy server");
                    }
                    else
                    {
                        if (inet.CustomProxyUrl == null)
                        {
                            AppendToOutput("Using manually setup proxy server with a null url");
                        }
                        else {
                            AppendToOutput("Using manually setup proxy server:" + inet.CustomProxyUrl);
                        }
                        
                    }

                    if (inet.IsUsingDefaultCredentials)
                    {
                        AppendToOutput("Using default credentials");
                    }
                    else
                    {
                        AppendToOutput("Using manual credentials:" + (!String.IsNullOrEmpty(txtDomain.Text) ? txtDomain.Text + "\\" : "") + txtUsername.Text);
                    }
                }
                
                
                
                AppendToOutput("Attempting to download file...");
                if (inet.TestWithUrl(txtTestUrl.Text))
                {
                    AppendToOutput("Downloaded OK");
                }
                else
                {
                    AppendToOutput("Test failed");
                }
                

            }
            catch (Exception ex)
            {
                AppendToOutput("ERROR:" + ex.Message);
            }
        }
     
        /// <summary>
        /// Update the proxy server settings when this check is clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void chkUseProxyServer_CheckedChanged(object sender, EventArgs e)
        {
            
            UpdateFormStatus();
        }

        /// <summary>
        /// Updates the status of all the form elements
        /// </summary>
        private void UpdateFormStatus()
        {
            txtProxyServerAddress.Enabled = chkUseProxyServer.Checked && !chkUseDefaultProxy.Checked;
            chkUseDefaultProxy.Enabled = chkUseProxyServer.Checked;
            chkUseDefaultCreds.Enabled = chkUseProxyServer.Checked;
            txtUsername.Enabled = chkUseProxyServer.Checked && !chkUseDefaultCreds.Checked;
            txtPassword.Enabled = chkUseProxyServer.Checked && !chkUseDefaultCreds.Checked;
            txtDomain.Enabled = chkUseProxyServer.Checked && !chkUseDefaultCreds.Checked;
            butUpdateAddress.Enabled = chkUseProxyServer.Checked && !chkUseDefaultProxy.Checked;
            butUpdateCreds.Enabled = chkUseProxyServer.Checked && !chkUseDefaultCreds.Checked;
        }

        /// <summary>
        /// Update the field values based on the internetconnection settings
        /// </summary>
        private void UpdateFieldValues()
        {
            chkUseProxyServer.Checked = inet.UseProxy;
            txtProxyServerAddress.Text = inet.CustomProxyUrl != null ? inet.CustomProxyUrl : "";
            chkUseDefaultProxy.Checked = inet.UseDefaultProxy;
            chkUseDefaultCreds.Checked = inet.IsUsingDefaultCredentials;
            if (inet.UseDefaultProxy)
            {
                txtProxyServerAddress.Text = "[default]";
            }
            else if (inet.CustomProxyUrl != null) 
            {
                txtProxyServerAddress.Text = inet.CustomProxyUrl;
            }
        }

        /// <summary>
        /// Standard form load event that sets the condition of the form
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void UpdateInternetSettings_Load(object sender, EventArgs e)
        {
            UpdateFieldValues();
            UpdateFormStatus();
        }

        /// <summary>
        /// Update the proxy server settings when this check is clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void chkUseDefaultProxy_CheckedChanged(object sender, EventArgs e)
        {
            UpdateFormStatus();
            inet.UseDefaultProxy = chkUseDefaultProxy.Checked;
            if (inet.UseDefaultProxy)
            {
                txtProxyServerAddress.Text = "[default]";
            }
            else if (inet.CustomProxyUrl != null)
            {
                txtProxyServerAddress.Text = inet.CustomProxyUrl;
            }
            else
            {
                txtProxyServerAddress.Text = "";
            }
        }

        /// <summary>
        /// Update the proxy server settings when this check is clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void chkUseDefaultCreds_CheckedChanged(object sender, EventArgs e)
        {
            UpdateFormStatus();
            if (chkUseDefaultCreds.Checked)
            {
                inet.SetDefaultCredentials();
            }
            else
            {
                inet.SetNetworkCredentials(txtUsername.Text, txtPassword.Text, txtDomain.Text);
            }
        }

        /// <summary>
        /// Update the proxy url
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butUpdateAddress_Click(object sender, EventArgs e)
        {
            inet.CustomProxyUrl = txtProxyServerAddress.Text;
        }

        /// <summary>
        /// Update the credentials being used
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butUpdateCreds_Click(object sender, EventArgs e)
        {
            inet.SetNetworkCredentials(txtUsername.Text, txtPassword.Text, txtDomain.Text);
            chkUseDefaultCreds.Checked = false;
        }


    }
}